CREATE TABLE "MDPROJECT"."Account" (
  "AutoId" int NOT NULL IDENTITY(1, 1),
  "AccountId" varchar(36) NOT NULL,
  "MobilePhone" varchar(32) DEFAULT NULL,
  "Email" varchar(128) DEFAULT NULL,
  "Password" varchar(64) DEFAULT NULL,
  "CreateTime" datetime(6) DEFAULT NULL,
  "UpdateTime" datetime(6) DEFAULT NULL,
  "Status" int DEFAULT NULL,
  "SourceType" int DEFAULT NULL,
  PRIMARY KEY ("AutoId")
);

CREATE TABLE "MDPROJECT"."Account_Authentication" (
  "AutoId" int NOT NULL IDENTITY(1, 1),
  "SourceId" varchar(128) DEFAULT NULL,
  "AuthType" int DEFAULT NULL,
  "AccountId" varchar(36) DEFAULT NULL,
  "Account" varchar(128) DEFAULT NULL,
  "Token" varchar(256) DEFAULT NULL,
  "Status" int DEFAULT NULL,
  "Number" int DEFAULT NULL,
  "ProjectId" varchar(36) DEFAULT NULL,
  "CreateAccountId" varchar(36) DEFAULT NULL,
  "CreateTime" datetime(6) DEFAULT NULL,
  "UpdateTime" datetime(6) DEFAULT NULL,
  "VerifyCode" varchar(10) DEFAULT NULL,
  "LastModifyAccountId" varchar(36) DEFAULT NULL,
  PRIMARY KEY ("AutoId")
);

CREATE TABLE "MDPROJECT"."Account_Bind_Email" (
  "AutoId" int NOT NULL IDENTITY(1, 1),
  "AccountId" varchar(36) DEFAULT NULL,
  "Email" varchar(50) DEFAULT NULL,
  "ProjectId" varchar(36) DEFAULT NULL,
  "CreateTime" datetime(6) DEFAULT NULL,
  "UserId" varchar(36) DEFAULT NULL,
  "IsVerify" int DEFAULT NULL,
  "State" int DEFAULT NULL,
  PRIMARY KEY ("AutoId")
);

CREATE TABLE "MDPROJECT"."Account_Detail" (
  "AutoId" int NOT NULL IDENTITY(1, 1),
  "AccountId" varchar(36) DEFAULT NULL,
  "Name" varchar(128) DEFAULT NULL,
  "Title" varchar(128) DEFAULT NULL,
  "Description" varchar(512) DEFAULT NULL,
  "StartDate" varchar(10) DEFAULT NULL,
  "EndDate" varchar(10) DEFAULT NULL,
  "DetailType" int DEFAULT NULL,
  "CreateTime" datetime(6) DEFAULT NULL,
  "UpdateTime" datetime(6) DEFAULT NULL,
  PRIMARY KEY ("AutoId")
);

CREATE TABLE "MDPROJECT"."Account_Friends" (
  "AutoId" int NOT NULL IDENTITY(1, 1),
  "AccountIdA" varchar(36) DEFAULT NULL,
  "AccountIdB" varchar(36) DEFAULT NULL,
  "Status" int DEFAULT NULL,
  "Message" varchar(100) DEFAULT NULL,
  "CreateAccountId" varchar(36) DEFAULT NULL,
  "CreateTime" datetime(6) DEFAULT NULL,
  "UpdateTime" datetime(6) DEFAULT NULL,
  PRIMARY KEY ("AutoId")
);

CREATE TABLE "MDPROJECT"."Account_Medal" (
  "AutoId" int NOT NULL IDENTITY(1, 1),
  "MedalId" varchar(36) NOT NULL,
  "ProjectId" varchar(36) DEFAULT NULL,
  "IsSystem" bit DEFAULT NULL,
  "MedalName" varchar(512) DEFAULT NULL,
  "MedalType" int DEFAULT NULL,
  "SysMedalType" int DEFAULT NULL,
  "Description" varchar(1024) DEFAULT NULL,
  "IsEnable" bit DEFAULT NULL,
  "Remark" varchar(1024) DEFAULT NULL,
  "LargePath" varchar(512) DEFAULT NULL,
  "MiddlePath" varchar(512) DEFAULT NULL,
  "SmallPath" varchar(512) DEFAULT NULL,
  "CreateAccount" varchar(36) DEFAULT NULL,
  "CreateTime" datetime(6) DEFAULT NULL,
  "UpdateTime" datetime(6) DEFAULT NULL,
  PRIMARY KEY ("AutoId")
);

CREATE TABLE "MDPROJECT"."Account_MedalGrantLog" (
  "AutoId" int NOT NULL IDENTITY(1, 1),
  "GrantId" varchar(36) NOT NULL,
  "MedalId" varchar(36) DEFAULT NULL,
  "ProjectId" varchar(36) DEFAULT NULL,
  "FromId" varchar(36) DEFAULT NULL,
  "ToAccountId" varchar(36) DEFAULT NULL,
  "Remark" varchar(1024) DEFAULT NULL,
  "IsShow" bit DEFAULT NULL,
  "IsGet" bit DEFAULT NULL,
  "CreateTime" datetime(6) DEFAULT NULL,
  "UpdateTime" datetime(6) DEFAULT NULL,
  PRIMARY KEY ("AutoId")
);

CREATE TABLE "MDPROJECT"."Account_Scale" (
  "AutoID" int NOT NULL IDENTITY(1, 1),
  "AccountId" varchar(36) DEFAULT NULL,
  "Type" int DEFAULT NULL,
  "CreateTime" datetime(6) DEFAULT NULL,
  PRIMARY KEY ("AutoID")
);

CREATE TABLE "MDPROJECT"."Account_Setting" (
  "AutoId" int NOT NULL IDENTITY(1, 1),
  "AccountId" varchar(36) DEFAULT NULL,
  "SettingName" varchar(64) DEFAULT NULL,
  "SettingValue" varchar(512) DEFAULT NULL,
  "CreateTime" datetime(6) DEFAULT NULL,
  "UpdateTime" datetime(6) DEFAULT NULL,
  PRIMARY KEY ("AutoId")
);

CREATE TABLE "MDPROJECT"."AccountExpand" (
  "AutoId" int NOT NULL IDENTITY(1, 1),
  "AccountId" varchar(36) NOT NULL,
  "Mark" int DEFAULT NULL,
  "LeftMark" int DEFAULT NULL,
  "Num_Login" int DEFAULT NULL,
  "Num_View" int DEFAULT NULL,
  "Num_Post" int DEFAULT NULL,
  "Num_Comment" int DEFAULT NULL,
  "LastLoginTime" datetime(6) DEFAULT NULL,
  "CurrentLoginTime" datetime(6) DEFAULT NULL,
  PRIMARY KEY ("AutoId")
);

CREATE TABLE "MDPROJECT"."AccountInfo" (
  "AutoId" int NOT NULL IDENTITY(1, 1),
  "AccountId" varchar(36) NOT NULL,
  "CompanyName" varchar(128) DEFAULT NULL,
  "Profession" varchar(128) DEFAULT NULL,
  "Avatar" varchar(128) DEFAULT NULL,
  "Fullname" varchar(128) DEFAULT NULL,
  "Gender" int DEFAULT NULL,
  "Birthdate" date DEFAULT NULL,
  "IM_QQ" varchar(16) DEFAULT NULL,
  "SNS_Sina" varchar(128) DEFAULT NULL,
  "SNS_QQ" varchar(128) DEFAULT NULL,
  "SNS_Linkedin" varchar(128) DEFAULT NULL,
  "WeiXin" varchar(128) DEFAULT NULL,
  "AppId" varchar(36) DEFAULT NULL,
  "CreateTime" datetime(6) DEFAULT NULL,
  "FirstCode" varchar(2) DEFAULT NULL,
  "Address" varchar(500) DEFAULT NULL,
  "ContactMobilePhone" varchar(32) DEFAULT NULL,
  "UpdateTime" datetime(6) DEFAULT NULL,
  PRIMARY KEY ("AutoId")
);

CREATE TABLE "MDPROJECT"."AccountStatistic" (
  "AutoId" int NOT NULL IDENTITY(1, 1),
  "AccountID" varchar(36) NOT NULL,
  "CompanyName" varchar(128) DEFAULT NULL,
  "Fullname" varchar(128) DEFAULT NULL,
  "Gender" int DEFAULT NULL,
  "Birthdate" datetime(6) DEFAULT NULL,
  "IM_QQ" varchar(16) DEFAULT NULL,
  "MobilePhone" varchar(32) DEFAULT NULL,
  "Email" varchar(128) DEFAULT NULL,
  "Status" int DEFAULT NULL,
  "SNS_Sina" varchar(128) DEFAULT NULL,
  "SNS_QQ" varchar(128) DEFAULT NULL,
  "SNS_Linkedin" varchar(128) DEFAULT NULL,
  "WeiXin" varchar(128) DEFAULT NULL,
  "CreateTime" datetime(6) DEFAULT NULL,
  "AppId" varchar(36) DEFAULT NULL,
  "FromRegister" varchar(100) DEFAULT NULL,
  "Num_Login" int DEFAULT NULL,
  "Num_View" int DEFAULT NULL,
  "Num_Post" int DEFAULT NULL,
  "Num_Comment" int DEFAULT NULL,
  "Num_Task" int DEFAULT NULL,
  "Num_TaskComment" int DEFAULT NULL,
  "Num_CreateCalendar" int DEFAULT NULL,
  "Num_ParticipateCalendar" int DEFAULT NULL,
  "Num_File" int DEFAULT NULL,
  "Num_Image" int DEFAULT NULL,
  "Num_Voice" int DEFAULT NULL,
  "Num_Video" int DEFAULT NULL,
  "VIPEndDate" datetime(6) DEFAULT NULL,
  "LastLoginTime" datetime(6) DEFAULT NULL,
  "NowMonthFlow" int DEFAULT NULL,
  "FlowResetDay" int DEFAULT NULL,
  "StorageSpace" int DEFAULT NULL,
  "Num_Invite" int DEFAULT NULL,
  "Num_Project" int DEFAULT NULL,
  "Avatar" varchar(128) DEFAULT NULL,
  "UpdateTime" datetime(6) DEFAULT NULL,
  PRIMARY KEY ("AutoId")
);

CREATE TABLE "MDPROJECT"."Project" (
  "AutoID" int NOT NULL IDENTITY(1, 1),
  "ProjectID" varchar(36) NOT NULL,
  "CompanyName" varchar(128) DEFAULT NULL,
  "CompanyNameEn" varchar(256) DEFAULT NULL,
  "CompanyDisplayName" varchar(128) DEFAULT NULL,
  "Status" int DEFAULT NULL,
  "GeographyID" int DEFAULT NULL,
  "IndustryID" int DEFAULT NULL,
  "Balance" decimal(18,4) DEFAULT NULL,
  "CreateUser" varchar(36) DEFAULT NULL,
  "LastModifyUser" varchar(36) DEFAULT NULL,
  "ParentID" varchar(36) DEFAULT NULL,
  "CreateTime" datetime(6) DEFAULT NULL,
  "UpdateTime" datetime(6) DEFAULT NULL,
  PRIMARY KEY ("AutoID")
);

CREATE TABLE "MDPROJECT"."Project_Department"
(
    "AutoID"          int NOT NULL IDENTITY(1, 1),
    "DepartmentID"    varchar(36) NOT NULL,
    "DepartmentName"  varchar(128)      DEFAULT NULL,
    "CreateUser"      varchar(36)          DEFAULT NULL,
    "LastModifyUser"  varchar(36)          DEFAULT NULL,
    "ProjectID"       varchar(36)          DEFAULT NULL,
    "MappingGroupID"  varchar(36)          DEFAULT NULL,
    "CreateTime"      datetime(6) DEFAULT NULL,
    "UpdateTime"      datetime(6) DEFAULT NULL,
    "ParentId"        varchar(36)          DEFAULT NULL,
    "ChargeAccountId" varchar(1024)     DEFAULT NULL,
    "SortIndex"       bigint NOT NULL DEFAULT 0,
    "Deleted"         bit   NOT NULL DEFAULT '0',
    PRIMARY KEY ("AutoID")
);


CREATE TABLE "MDPROJECT"."Project_DepartmentAccount" (
  "AutoId" int NOT NULL IDENTITY(1, 1),
  "ProjectId" varchar(36) NOT NULL,
  "DepartmentId" varchar(36) NOT NULL,
  "AccountId" varchar(36) NOT NULL,
  "IsMainDepartment" bit NOT NULL DEFAULT '0',
  "IsManager" bit NOT NULL DEFAULT '0',
  "CreateTime" datetime(6) NOT NULL,
  "CreateUser" varchar(36) DEFAULT NULL,
  "UpdateTime" datetime(6) NOT NULL,
  "LastModifyUser" varchar(36) DEFAULT NULL,
  "Deleted" bit NOT NULL DEFAULT '0',
  "DisplayOrder" int NOT NULL DEFAULT 0,
  PRIMARY KEY ("AutoId")
);

CREATE TABLE "MDPROJECT"."Project_JobAccount" (
  "AutoId" int NOT NULL IDENTITY(1, 1),
  "ProjectId" varchar(36) NOT NULL,
  "JobId" varchar(36) NOT NULL,
  "AccountId" varchar(36) NOT NULL,
  "CreateUser" varchar(36) DEFAULT NULL,
  "CreateTime" datetime(6) NOT NULL,
  "UpdateTime" datetime(6) NOT NULL,
  "LastModifyUser" varchar(36) DEFAULT NULL,
  "DepartmentId" varchar(36) DEFAULT NULL,
  PRIMARY KEY ("AutoId")
);

CREATE TABLE "MDPROJECT"."Project_Finance" (
  "AutoID" int NOT NULL IDENTITY(1, 1),
  "ProjectID" varchar(36) NOT NULL,
  "Address" varchar(256) DEFAULT NULL,
  "RecipientName" varchar(64) DEFAULT NULL,
  "Postcode" varchar(16) DEFAULT NULL,
  "MobilePhone" varchar(32) DEFAULT NULL,
  "ContactPhone" varchar(32) DEFAULT NULL,
  "Fax" varchar(32) DEFAULT NULL,
  "Email" varchar(128) DEFAULT NULL,
  "EmailRecipientName" varchar(64) DEFAULT NULL,
  "InvoiceType" int DEFAULT NULL,
  "TaxNumber" varchar(64) DEFAULT NULL,
  "TaxBank" varchar(128) DEFAULT NULL,
  "TaxBankNumber" varchar(64) DEFAULT NULL,
  "TaxRegAddress" varchar(256) DEFAULT NULL,
  "TaxRegContactPhone" varchar(32) DEFAULT NULL,
  "IsGeneralTaxpayer" bit DEFAULT NULL,
  "CreateUser" varchar(36) DEFAULT NULL,
  "LastModifyUser" varchar(36) DEFAULT NULL,
  "CreateTime" datetime(6) DEFAULT NULL,
  "UpdateTime" datetime(6) DEFAULT NULL,
  PRIMARY KEY ("AutoID")
);

CREATE TABLE "MDPROJECT"."Project_Job" (
  "AutoID" int NOT NULL IDENTITY(1, 1),
  "JobID" varchar(36) NOT NULL,
  "JobName" varchar(128) DEFAULT NULL,
  "CreateUser" varchar(36) DEFAULT NULL,
  "LastModifyUser" varchar(36) DEFAULT NULL,
  "ProjectID" varchar(36) DEFAULT NULL,
  "CreateTime" datetime(6) DEFAULT NULL,
  "UpdateTime" datetime(6) DEFAULT NULL,
  PRIMARY KEY ("AutoID")
);

CREATE TABLE "MDPROJECT"."Project_Setting" (
  "AutoID" int NOT NULL IDENTITY(1, 1),
  "ProjectID" varchar(36) DEFAULT NULL,
  "SettingName" varchar(64) DEFAULT NULL,
  "SettingValue" varchar(255) DEFAULT NULL,
  "CreateUser" varchar(36) DEFAULT NULL,
  "LastModifyUser" varchar(36) DEFAULT NULL,
  "CreateTime" datetime(6) DEFAULT NULL,
  "UpdateTime" datetime(6) DEFAULT NULL,
  PRIMARY KEY ("AutoID")
);

CREATE TABLE "MDPROJECT"."Project_Source" (
  "AutoID" int NOT NULL IDENTITY(1, 1),
  "Source" int DEFAULT NULL,
  "CreateUser" varchar(36) DEFAULT NULL,
  "ProjectID" varchar(36) DEFAULT NULL,
  "CreateTime" datetime(6) DEFAULT NULL,
  PRIMARY KEY ("AutoID")
);


CREATE TABLE "MDPROJECT"."Project_WorkSite" (
  "AutoID" int NOT NULL IDENTITY(1, 1),
  "WorkSiteID" varchar(36) NOT NULL,
  "WorkSiteName" varchar(128) DEFAULT NULL,
  "CreateUser" varchar(36) DEFAULT NULL,
  "LastModifyUser" varchar(36) DEFAULT NULL,
  "ProjectID" varchar(36) DEFAULT NULL,
  "CreateTime" datetime(6) DEFAULT NULL,
  "UpdateTime" datetime(6) DEFAULT NULL,
  PRIMARY KEY ("AutoID")
);

CREATE TABLE "MDPROJECT"."ProjectAuthorization" (
  "AutoId" int NOT NULL IDENTITY(1, 1),
  "ProjectId" varchar(36) DEFAULT NULL,
  "AppKey" varchar(100) DEFAULT NULL,
  "SecretKey" varchar(100) DEFAULT NULL,
  "ExpireTime" datetime(6) DEFAULT NULL,
  "Type" int DEFAULT NULL,
  "CreateTime" datetime(6) DEFAULT NULL,
  "CreateAccountId" varchar(36) DEFAULT NULL,
  "Status" int DEFAULT NULL,
  "Sign" varchar(512) DEFAULT NULL,
  PRIMARY KEY ("AutoId")
);

CREATE TABLE "MDPROJECT"."RoutingAccount" (
  "AutoID" int NOT NULL IDENTITY(1, 1),
  "AccountId" varchar(36) DEFAULT NULL,
  "UserID" varchar(36) DEFAULT NULL,
  "ProjectID" varchar(36) DEFAULT NULL,
  "Status" int DEFAULT NULL,
  "ServerID" varchar(36) DEFAULT NULL,
  "CreateTime" datetime(6) DEFAULT NULL,
  "UpdateTime" datetime(6) DEFAULT NULL,
  "CompanyName" varchar(1000) DEFAULT NULL,
  "UserType" int DEFAULT NULL,
  PRIMARY KEY ("AutoID")
);

CREATE TABLE "MDPROJECT"."RoutingProject" (
  "AutoID" int NOT NULL IDENTITY(1, 1),
  "ProjectID" varchar(36) NOT NULL,
  "ParentID" varchar(36) DEFAULT NULL,
  "ServerID" varchar(36) DEFAULT NULL,
  "CompanyName" varchar(128) DEFAULT NULL,
  "SubDomain" varchar(64) DEFAULT NULL,
  "BaseAuthenticationDomain" varchar(128) DEFAULT NULL,
  "ExpandAuthenticationDomain" varchar(512) DEFAULT NULL,
  "CreateTime" datetime(6) DEFAULT NULL,
  "UpdateTime" datetime(6) DEFAULT NULL,
  PRIMARY KEY ("AutoID")
);

CREATE TABLE "MDPROJECT"."RoutingProjectExpand" (
  "AutoID" int NOT NULL IDENTITY(1, 1),
  "ProjectID" varchar(36) NOT NULL,
  "CompanyName" varchar(128) DEFAULT NULL,
  "IsEMail" bit DEFAULT NULL,
  "PaidType" int DEFAULT NULL,
  "Geography" int DEFAULT NULL,
  "Industry" int DEFAULT NULL,
  "Num_User" int DEFAULT NULL,
  "Num_Group" int DEFAULT NULL,
  "Num_Post" int DEFAULT NULL,
  "Num_Comment" int DEFAULT NULL,
  "Num_Pic" int DEFAULT NULL,
  "Num_Doc" int DEFAULT NULL,
  "Num_QA" int DEFAULT NULL,
  "Num_Task" int DEFAULT NULL,
  "Num_Sms" int DEFAULT NULL,
  "Filesize_Pic" decimal(20,3) DEFAULT NULL,
  "Filesize_Doc" decimal(20,3) DEFAULT NULL,
  "LoginCountByLastWeek" int DEFAULT NULL,
  "PostCountByLastWeek" int DEFAULT NULL,
  "CommentCountByLastWeek" int DEFAULT NULL,
  "LastLoginTime" datetime(6) DEFAULT NULL,
  "InvoiceType" int DEFAULT NULL,
  "CreateUser" varchar(36) DEFAULT NULL,
  "CreateTime" datetime(6) DEFAULT NULL,
  "UpdateTime" datetime(6) DEFAULT NULL,
  "Vitality" decimal(18,0) DEFAULT NULL,
  "Num_Calander" int DEFAULT NULL,
  "Num_Voice" int DEFAULT NULL,
  "Num_Video" int DEFAULT NULL,
  "Num_TaskReply" int DEFAULT NULL,
  "Num_Login" int DEFAULT NULL,
  PRIMARY KEY ("AutoID")
);

CREATE TABLE "MDPROJECT"."RoutingProjectExpandForOther" (
  "AutoID" int NOT NULL IDENTITY(1, 1),
  "ProjectID" varchar(36) NOT NULL,
  "Balance" decimal(10,2) DEFAULT NULL,
  "PayStatus" int DEFAULT NULL,
  "UpdateTime" datetime(6) DEFAULT NULL,
  PRIMARY KEY ("AutoID")
);

CREATE TABLE "MDPROJECT"."RoutingUserExpand" (
  "AutoID" int NOT NULL IDENTITY(1, 1),
  "UserID" varchar(36) DEFAULT NULL,
  "ProjectID" varchar(36) DEFAULT NULL,
  "CompanyName" varchar(128) DEFAULT NULL,
  "Num_ProjectUsers" int DEFAULT NULL,
  "Email" varchar(128) DEFAULT NULL,
  "Status" int DEFAULT NULL,
  "IsAdmin" int DEFAULT NULL,
  "UserType" int DEFAULT NULL,
  "Fullname" varchar(128) DEFAULT NULL,
  "Mark" int DEFAULT NULL,
  "LastMark" int DEFAULT NULL,
  "Grade" varchar(64) DEFAULT NULL,
  "Avatar" varchar(128) DEFAULT NULL,
  "Gender" int DEFAULT NULL,
  "Birthdate" date DEFAULT NULL,
  "Job" varchar(64) DEFAULT NULL,
  "Department" varchar(64) DEFAULT NULL,
  "City" varchar(64) DEFAULT NULL,
  "MobilePhone" varchar(32) DEFAULT NULL,
  "ContactPhone" varchar(32) DEFAULT NULL,
  "Num_Login" int DEFAULT NULL,
  "Num_View" int DEFAULT NULL,
  "Num_Follower" int DEFAULT NULL,
  "Num_Concern" int DEFAULT NULL,
  "Num_Post" int DEFAULT NULL,
  "Num_Comment" int DEFAULT NULL,
  "LastLoginTime" datetime(6) DEFAULT NULL,
  "CreateTime" datetime(6) DEFAULT NULL,
  "UpdateTime" datetime(6) DEFAULT NULL,
  "AccountID" varchar(36) DEFAULT NULL,
  "DepartmentId" varchar(36) DEFAULT NULL,
  "JobId" varchar(36) DEFAULT NULL,
  PRIMARY KEY ("AutoID")
);

CREATE TABLE "MDPROJECT"."FixedData" (
  "AutoID" int NOT NULL IDENTITY(1, 1),
  "DataID" int DEFAULT NULL,
  "DataName" varchar(128) DEFAULT NULL,
  "ParentDataID" int DEFAULT NULL,
  "DataType" int DEFAULT NULL,
  PRIMARY KEY ("AutoID")
);

CREATE TABLE "MDPROJECT"."ImportUserInfo" (
  "AutoId" int NOT NULL IDENTITY(1, 1),
  "ProjectID" varchar(36) DEFAULT NULL,
  "Status" int DEFAULT NULL,
  "Fullname" varchar(100) DEFAULT NULL,
  "Account" varchar(100) DEFAULT NULL,
  "Department" varchar(100) DEFAULT NULL,
  "Job" varchar(100) DEFAULT NULL,
  "CompanyName" varchar(100) DEFAULT NULL,
  "WorkSite" varchar(100) DEFAULT NULL,
  "JobNumber" varchar(100) DEFAULT NULL,
  "ContactPhone" varchar(100) DEFAULT NULL,
  "CreateAccountId" varchar(36) DEFAULT NULL,
  "CreateTime" datetime(6) DEFAULT NULL,
  "UpdateTime" datetime(6) DEFAULT NULL,
  "DepartmentId" varchar(36) DEFAULT NULL,
  "AccountId" varchar(36) DEFAULT NULL,
  "WorkSiteId" varchar(36) DEFAULT NULL,
  "JobId" varchar(36) DEFAULT NULL,
  "DepartmentIds" varchar(1000) DEFAULT NULL,
  "JobIds" varchar(1000) DEFAULT NULL,
  "OrgRoleIds" varchar(1000) DEFAULT NULL,
  "UseMultiJobs" bit DEFAULT '0' NOT NULL,
  "DepartmentJobIdMaps" varchar(2000) DEFAULT NULL,
  PRIMARY KEY ("AutoId")
);

CREATE TABLE "MDPROJECT"."LinkAuthentication" (
  "AutoId" int NOT NULL IDENTITY(1, 1),
  "SourceId" varchar(128) DEFAULT NULL,
  "InviteFromType" int DEFAULT NULL,
  "Token" varchar(255) DEFAULT NULL,
  "ProjectId" varchar(36) DEFAULT NULL,
  "CreateAccountId" varchar(36) DEFAULT NULL,
  "LinkFromType" int DEFAULT NULL,
  "DeadTime" datetime(6) DEFAULT NULL,
  "CreateTime" datetime(6) DEFAULT NULL,
  "UpdateTime" datetime(6) DEFAULT NULL,
  PRIMARY KEY ("AutoId")
);

CREATE TABLE "MDPROJECT"."UsersCard" (
  "AutoId" int NOT NULL IDENTITY(1, 1),
  "UserId" varchar(36) NOT NULL,
  "AccountId" varchar(36) DEFAULT NULL,
  "ProjectId" varchar(36) DEFAULT NULL,
  "CompanyName" varchar(128) DEFAULT NULL,
  "Fullname" varchar(128) DEFAULT NULL,
  "Job" varchar(64) DEFAULT NULL,
  "Department" varchar(128) DEFAULT NULL,
  "ContactPhone" varchar(32) DEFAULT NULL,
  "WorkSite" varchar(128) DEFAULT NULL,
  "JobNumber" varchar(128) DEFAULT NULL,
  "Status" int DEFAULT NULL,
  "LastModifyUser" varchar(36) DEFAULT NULL,
  "CreateTime" datetime(6) DEFAULT NULL,
  "UpdateTime" datetime(6) DEFAULT NULL,
  "DepartmentId" varchar(36) DEFAULT NULL,
  "WorkSiteId" varchar(36) DEFAULT NULL,
  "JobId" varchar(36) DEFAULT NULL,
  "UseMultiJobs" bit DEFAULT '0' NOT NULL,
  PRIMARY KEY ("AutoId")
);

CREATE TABLE "MDPROJECT"."Role" (
  "AutoId" int NOT NULL IDENTITY(1, 1),
  "ProjectId" varchar(50) DEFAULT NULL,
  "RoleId" varchar(50) DEFAULT NULL,
  "RoleName" varchar(50) DEFAULT NULL,
  "CreateUser" varchar(50) DEFAULT NULL,
  "CreateTime" datetime DEFAULT NULL,
  "LastModifyUser" varchar(50) DEFAULT NULL,
  "UpdateTime" datetime DEFAULT NULL,
  "IsDelete" bit DEFAULT NULL,
  "EntityId" varchar(50) DEFAULT NULL,
  "EntityType" int DEFAULT NULL,
  "RoleType" int DEFAULT NULL,
  PRIMARY KEY ("AutoId")
);

CREATE TABLE "MDPROJECT"."RolePermission" (
  "AutoId" int NOT NULL IDENTITY(1, 1),
  "ProjectId" varchar(50) DEFAULT NULL,
  "RoleId" varchar(50) DEFAULT NULL,
  "PermissionId" int DEFAULT NULL,
  "CreateUser" varchar(50) DEFAULT NULL,
  "CreateTime" datetime DEFAULT NULL,
  "LastModifyUser" varchar(50) DEFAULT NULL,
  "UpdateTime" datetime DEFAULT NULL,
  "EntityId" varchar(50) DEFAULT NULL,
  "EntityType" int DEFAULT NULL,
  PRIMARY KEY ("AutoId")
);

CREATE TABLE "MDPROJECT"."Permission" (
  "AutoId" int NOT NULL IDENTITY(1, 1),
  "TypeId" int DEFAULT NULL,
  "TypeName" varchar(100) DEFAULT NULL,
  "PermissionId" int DEFAULT NULL,
  "PermissionName" varchar(100) DEFAULT NULL,
  "IsTypeAdmin" bit DEFAULT NULL,
  "Description" varchar(200) DEFAULT NULL,
  "ParentId" int DEFAULT NULL,
  "OrderId" int DEFAULT NULL,
  "EntityType" int DEFAULT NULL,
  "HasChild" bit DEFAULT NULL,
  PRIMARY KEY ("AutoId")
);

CREATE TABLE "MDPROJECT"."UserRole" (
  "AutoId" int NOT NULL IDENTITY(1, 1),
  "AccountId" varchar(50) DEFAULT NULL,
  "ProjectId" varchar(50) DEFAULT NULL,
  "RoleId" varchar(50) DEFAULT NULL,
  "Status" int DEFAULT NULL,
  "CreateUser" varchar(50) DEFAULT NULL,
  "CreateTime" datetime DEFAULT NULL,
  "LastModifyUser" varchar(50) DEFAULT NULL,
  "UpdateTime" datetime DEFAULT NULL,
  "UserScopeType" int DEFAULT NULL,
  "EntityId" varchar(50) DEFAULT NULL,
  "EntityType" int DEFAULT NULL,
  "OriginId" varchar(50) DEFAULT NULL,
  "OriginName" varchar(50) DEFAULT NULL,
  "OriginType" int DEFAULT NULL,
  PRIMARY KEY ("AutoId")
);

CREATE TABLE "MDPROJECT"."Project_UserRule" (
  "AutoId" int NOT NULL IDENTITY(1, 1),
  "ProjectId" varchar(36) NOT NULL,
  "RuleId" varchar(36) NOT NULL,
  "CreateTime" datetime(6) NOT NULL,
  "CreateUser" varchar(36) NOT NULL,
  "UpdateTime" datetime(6) NOT NULL,
  "LastModifyUser" varchar(36) NOT NULL,
  "RuleType" int NOT NULL DEFAULT '10',
  PRIMARY KEY ("AutoId")
);

CREATE TABLE "MDPROJECT"."Project_UserRuleItem" (
  "AutoId" int NOT NULL IDENTITY(1, 1),
  "ProjectId" varchar(36) NOT NULL,
  "RuleId" varchar(36) NOT NULL,
  "RuleItemType" int NOT NULL DEFAULT '0',
  "TargetId" varchar(50) NOT NULL,
  "TargetType" int NOT NULL DEFAULT '0',
  "CreateTime" datetime(6) NOT NULL,
  "CreateUser" varchar(36) NOT NULL,
  PRIMARY KEY ("AutoId")
);

CREATE TABLE "MDPROJECT"."Project_Organize" (
  "AutoID" int NOT NULL IDENTITY(1, 1),
  "OrganizeID" varchar(36) NOT NULL,
  "OrganizeGroupID" varchar(36) DEFAULT NULL,
  "OrganizeName" varchar(128) DEFAULT NULL,
  "ProjectID" varchar(36) NOT NULL,
  "Remark" text,
  "SortIndex" int NOT NULL,
  "CreateUser" varchar(36) DEFAULT NULL,
  "LastModifyUser" varchar(36) DEFAULT NULL,
  "CreateTime" datetime DEFAULT NULL,
  "UpdateTime" datetime DEFAULT NULL,
  PRIMARY KEY ("AutoID")
);

CREATE TABLE "MDPROJECT"."Project_OrganizeAccount" (
  "AutoId" int NOT NULL IDENTITY(1, 1),
  "ProjectId" varchar(36) NOT NULL,
  "OrganizeId" varchar(36) NOT NULL,
  "AccountId" varchar(36) NOT NULL,
  "CreateUser" varchar(36) DEFAULT NULL,
  "CreateTime" datetime NOT NULL,
  "UpdateTime" datetime NOT NULL,
  "LastModifyUser" varchar(36) DEFAULT NULL,
  PRIMARY KEY ("AutoId")
);

CREATE TABLE "MDPROJECT"."Project_OrgRoleChargeDepartment" (
  AutoId int NOT NULL IDENTITY(1, 1),
  ProjectId varchar(36) NOT NULL,
  OrgRoleId varchar(36) NOT NULL,
  AccountId varchar(36) NOT NULL,
  DepartmentId varchar(36) NOT NULL,
  IsIncludeSub bit NOT NULL DEFAULT '1',
  CreateUser varchar(36) NOT NULL,
  CreateTime datetime NOT NULL,
  UpdateTime datetime NOT NULL,
  LastModifyUser varchar(36) NOT NULL,
  PRIMARY KEY (AutoId)
);

CREATE TABLE "MDPROJECT"."Project_OrgRoleGroup" (
  AutoID int NOT NULL IDENTITY(1, 1),
  ProjectID varchar(36) NOT NULL,
  OrganizeGroupID varchar(36) NOT NULL,
  OrganizeGroupName varchar(128),
  SortIndex int DEFAULT 0 NOT NULL,
  CreateUser varchar(36) NOT NULL,
  LastModifyUser varchar(36) NOT NULL,
  CreateTime datetime NOT NULL,
  UpdateTime datetime NOT NULL,
  PRIMARY KEY (AutoId)
);

CREATE INDEX idx_account_aid ON "MDPROJECT"."Account"("AccountId");
CREATE INDEX idx_amedal_mid ON "MDPROJECT"."Account_Medal"("MedalId");
CREATE INDEX idx_amedal_gid ON "MDPROJECT"."Account_MedalGrantLog"("GrantId");
CREATE INDEX idx_aexpand_aid ON "MDPROJECT"."AccountExpand"("AccountId");
CREATE INDEX idx_ainfo_aid ON "MDPROJECT"."AccountInfo"("AccountId");
CREATE INDEX idx_astatistic_aid ON "MDPROJECT"."AccountStatistic"("AccountID");
CREATE INDEX idx_project_pid ON "MDPROJECT"."Project"("ProjectID");
CREATE INDEX idx_pdept_pid_paid ON "MDPROJECT"."Project_Department"("ProjectID","ParentId");
CREATE INDEX idx_pdept_did_pid ON "MDPROJECT"."Project_Department"("DepartmentID","ProjectID");
CREATE INDEX idx_pda_pid_did_aid ON "MDPROJECT"."Project_DepartmentAccount"("ProjectId","DepartmentId","AccountId");
CREATE INDEX idx_pda_pid_aid ON "MDPROJECT"."Project_DepartmentAccount"("ProjectId","AccountId");
CREATE INDEX idx_pda_pid_did_ord ON "MDPROJECT"."Project_DepartmentAccount"("ProjectId","DepartmentId","DisplayOrder");
CREATE INDEX idx_pja_pid_jid_aid ON "MDPROJECT"."Project_JobAccount"("ProjectId","JobId","AccountId");
CREATE INDEX idx_pja_pid_aid ON "MDPROJECT"."Project_JobAccount"("ProjectId","AccountId");
CREATE INDEX idx_pf_pid ON "MDPROJECT"."Project_Finance"("ProjectID");
CREATE INDEX idx_pj_pid_jid ON "MDPROJECT"."Project_Job"("ProjectID","JobID");
CREATE INDEX idx_pj_jid ON "MDPROJECT"."Project_Job"("JobID");
CREATE INDEX idx_pw_pid_wid ON "MDPROJECT"."Project_WorkSite"("ProjectID","WorkSiteID");
CREATE INDEX idx_pw_wid ON "MDPROJECT"."Project_WorkSite"("WorkSiteID");
CREATE UNIQUE INDEX uidx_ra_pid_aid ON "MDPROJECT"."RoutingAccount"("ProjectID","AccountId");
CREATE INDEX idx_ra_aid_pid ON "MDPROJECT"."RoutingAccount"("AccountId","ProjectID");
CREATE INDEX idx_rp_pid ON "MDPROJECT"."RoutingProject"("ProjectID");
CREATE INDEX idx_rpe_pid ON "MDPROJECT"."RoutingProjectExpand"("ProjectID");
CREATE INDEX idx_rpefo_pid ON "MDPROJECT"."RoutingProjectExpandForOther"("ProjectID");
CREATE UNIQUE INDEX uidx_ucard_pid_aid ON "MDPROJECT"."UsersCard"("ProjectId","AccountId");
CREATE INDEX idx_ucard_aid_pid ON "MDPROJECT"."UsersCard"("AccountId","ProjectId");
CREATE INDEX idx_role_pid_rid ON "MDPROJECT"."Role"("ProjectId","RoleId");
CREATE INDEX idx_role_rid_eid_etype ON "MDPROJECT"."Role"("RoleId","EntityId","EntityType");
CREATE INDEX idx_rp_pid_pmsid ON "MDPROJECT"."RolePermission"("ProjectId","PermissionId");
CREATE INDEX idx_rp_pid_rid ON "MDPROJECT"."RolePermission"("ProjectId","RoleId");
CREATE INDEX idx_rp_pid_eid_etype ON "MDPROJECT"."RolePermission"("PermissionId","EntityId","EntityType");
CREATE INDEX idx_rp_rid_eid_etype ON "MDPROJECT"."RolePermission"("RoleId","EntityId","EntityType");
CREATE INDEX idx_perm_pid_etype ON "MDPROJECT"."Permission"("PermissionId","EntityType");
CREATE INDEX idx_ur_aid_pid ON "MDPROJECT"."UserRole"("AccountId","ProjectId");
CREATE INDEX idx_ur_pid_rid ON "MDPROJECT"."UserRole"("ProjectId","RoleId");
CREATE INDEX idx_ur_etype_eid_aid ON "MDPROJECT"."UserRole"("EntityType","EntityId","AccountId");
CREATE INDEX idx_ur_etype_eid_rid ON "MDPROJECT"."UserRole"("EntityType","EntityId","RoleId");
CREATE INDEX idx_pur_pid ON "MDPROJECT"."Project_UserRule"("ProjectId");
CREATE INDEX idx_pur_rid ON "MDPROJECT"."Project_UserRule"("RuleId");
CREATE INDEX idx_puri_pid_rid ON "MDPROJECT"."Project_UserRuleItem"("ProjectId","RuleId");
CREATE INDEX idx_po_pid_oid ON "MDPROJECT"."Project_Organize"("ProjectID","OrganizeID");
CREATE INDEX idx_pora_pid_oid_aid ON "MDPROJECT"."Project_OrganizeAccount"("ProjectId","OrganizeId","AccountId");
CREATE INDEX idx_porcd_pid_orid_aid ON "MDPROJECT"."Project_OrgRoleChargeDepartment"("ProjectId","OrgRoleId","AccountId");
CREATE INDEX idx_porg_pid ON "MDPROJECT"."Project_OrgRoleGroup"("ProjectId");