CREATE TABLE calendar (
  autoid INT PRIMARY KEY AUTO_INCREMENT,
  calendarid varchar(64) NOT NULL,
  calendarname varchar(512) DEFAULT NULL,
  starttime timestamp without time zone DEFAULT NULL,
  endtime timestamp without time zone DEFAULT NULL,
  isallday boolean DEFAULT NULL,
  address varchar(512) DEFAULT NULL,
  description varchar(1024) DEFAULT NULL,
  types int DEFAULT NULL,
  groupid varchar(512) DEFAULT NULL,
  projectid varchar(64) DEFAULT NULL,
  sequence int DEFAULT '0',
  isrecur boolean DEFAULT false,
  frequency int DEFAULT '0',
  interval int DEFAULT '1',
  recurcount int DEFAULT '0',
  untildate timestamp without time zone DEFAULT NULL,
  weekday int DEFAULT NULL,
  eventstart timestamp without time zone DEFAULT NULL,
  eventend timestamp without time zone DEFAULT NULL,
  createuser varchar(64) DEFAULT NULL,
  appid varchar(64) DEFAULT NULL,
  isdelete boolean DEFAULT false,
  createtime timestamp without time zone DEFAULT NULL,
  updatetime timestamp without time zone DEFAULT NULL,
  locked boolean DEFAULT NULL,
  createaccountid varchar(64) DEFAULT NULL,
  isprivate boolean NOT NULL DEFAULT false
);

CREATE TABLE calendar_category (
  autoid INT PRIMARY KEY AUTO_INCREMENT,
  catid varchar(64) NOT NULL,
  userid varchar(64) DEFAULT NULL,
  color int DEFAULT NULL,
  catname varchar(400) DEFAULT NULL,
  projectid varchar(64) DEFAULT NULL,
  createtime timestamp without time zone DEFAULT NULL,
  accountid varchar(64) DEFAULT NULL
);

CREATE TABLE calendar_member (
  autoid INT PRIMARY KEY AUTO_INCREMENT,
  calendarid varchar(64) NOT NULL,
  userid varchar(64) DEFAULT NULL,
  email varchar(128) DEFAULT NULL,
  mobilephone varchar(32) DEFAULT NULL,
  catid varchar(128) DEFAULT NULL,
  groupid varchar(64) DEFAULT NULL,
  types int DEFAULT NULL,
  status int DEFAULT NULL,
  remark varchar(1024) DEFAULT NULL,
  createtime timestamp without time zone DEFAULT NULL,
  remindtime int DEFAULT NULL,
  remindtype int DEFAULT NULL,
  updatetime timestamp without time zone DEFAULT NULL,
  accountid varchar(64) DEFAULT NULL,
  projectid varchar(64) DEFAULT NULL,
  voiceremind boolean DEFAULT false
);

CREATE TABLE childcalendarrecurtime (
  autoid INT PRIMARY KEY AUTO_INCREMENT,
  calendarid varchar(64) NOT NULL,
  recurtime timestamp without time zone NOT NULL,
  starttime timestamp without time zone NOT NULL,
  status int DEFAULT NULL,
  calendarname varchar(512) DEFAULT NULL,
  endtime timestamp without time zone DEFAULT NULL,
  isallday boolean DEFAULT NULL,
  address varchar(512) DEFAULT NULL,
  description varchar(1024) DEFAULT NULL,
  types int DEFAULT NULL,
  groupid varchar(512) DEFAULT NULL,
  sequence int DEFAULT NULL,
  createtime timestamp without time zone DEFAULT NULL,
  updatetime timestamp without time zone DEFAULT NULL,
  createuser varchar(64) DEFAULT NULL,
  locked boolean DEFAULT NULL,
  projectid varchar(64) DEFAULT NULL,
  createaccountid varchar(64) DEFAULT NULL,
  isprivate boolean NOT NULL DEFAULT false
);

CREATE TABLE childcalendarrecurtimemember (
  autoid INT PRIMARY KEY AUTO_INCREMENT,
  calendarid varchar(64) NOT NULL,
  userid varchar(64) DEFAULT NULL,
  recurtime timestamp without time zone NOT NULL,
  email varchar(128) DEFAULT NULL,
  mobilephone varchar(32) DEFAULT NULL,
  groupid varchar(64) DEFAULT NULL,
  catid varchar(64) DEFAULT NULL,
  types int DEFAULT NULL,
  status int DEFAULT NULL,
  remark varchar(1024) DEFAULT NULL,
  createtime timestamp without time zone DEFAULT NULL,
  remindtime int DEFAULT NULL,
  remindtype int DEFAULT NULL,
  updatetime timestamp without time zone DEFAULT NULL,
  accountid varchar(64) DEFAULT NULL,
  projectid varchar(64) DEFAULT NULL,
  voiceremind boolean DEFAULT false
);

CREATE TABLE thirduser (
  autoid INT PRIMARY KEY AUTO_INCREMENT,
  thirdid varchar(50) NOT NULL,
  calendarid varchar(64) NOT NULL,
  recurtime timestamp without time zone DEFAULT NULL,
  createtime timestamp without time zone NOT NULL,
  edittime timestamp without time zone NOT NULL,
  nickname varchar(50) DEFAULT NULL,
  face varchar(200) DEFAULT NULL
);

CREATE TABLE user_calcategory_order (
  autoid INT PRIMARY KEY AUTO_INCREMENT,
  userid varchar(64) DEFAULT NULL,
  catid varchar(64) DEFAULT NULL,
  displayorder int DEFAULT NULL,
  projectid varchar(64) DEFAULT NULL,
  createtime timestamp without time zone DEFAULT NULL,
  accountid varchar(64) DEFAULT NULL
);

CREATE UNIQUE INDEX uk_c_calendarid ON calendar USING btree (calendarid);
CREATE INDEX idx_c_caid ON calendar USING btree (createaccountid);
CREATE INDEX idx_c_eventend ON calendar USING btree (eventend);
CREATE INDEX idx_c_starttime_calendarid ON calendar USING btree (starttime, calendarid);
CREATE UNIQUE INDEX uk_cc_catid ON calendar_category USING btree (catid);
CREATE INDEX idx_cc_aid_catid ON calendar_category USING btree (accountid, catid);
CREATE INDEX idx_cm_calendarid ON calendar_member USING btree (calendarid);
CREATE INDEX idx_cm_aid ON calendar_member USING btree (accountid);
CREATE UNIQUE INDEX uk_ccr_calendarid_recur ON childcalendarrecurtime USING btree (calendarid, recurtime);
CREATE INDEX idx_ccr_starttime_endtime ON childcalendarrecurtime USING btree (starttime, endtime);
CREATE INDEX idx_ccrtm_calendarid_recurtime_aid ON childcalendarrecurtimemember USING btree (calendarid, recurtime, accountid);
CREATE INDEX idx_tu_calendarid ON thirduser USING btree (calendarid);
CREATE INDEX idx_uco_aid_catid ON user_calcategory_order USING btree (accountid, catid);