CREATE TABLE account_actionlog (
  autoid INT PRIMARY KEY AUTO_INCREMENT,
  accountid varchar(36) DEFAULT NULL,
  title varchar(255) DEFAULT NULL,
  description varchar(512) DEFAULT NULL,
  type int DEFAULT NULL,
  ip varchar(32) DEFAULT NULL,
  projectid varchar(36) DEFAULT NULL,
  createtime timestamp without time zone DEFAULT NULL
);

CREATE TABLE account_costlog (
  autoid INT PRIMARY KEY AUTO_INCREMENT,
  accountid varchar(36) DEFAULT NULL,
  title varchar(255) DEFAULT NULL,
  costmark int DEFAULT NULL,
  leftmark int DEFAULT NULL,
  projectid varchar(36) DEFAULT NULL,
  createtime timestamp without time zone DEFAULT NULL
);

CREATE TABLE project_costlog (
  autoid INT PRIMARY KEY AUTO_INCREMENT,
  projectid varchar(36) DEFAULT NULL,
  type int DEFAULT NULL,
  title varchar(255) DEFAULT NULL,
  costmark numeric(18,4) DEFAULT NULL,
  leftmark numeric(18,4) DEFAULT NULL,
  createaccount varchar(36) DEFAULT NULL,
  createtime timestamp without time zone DEFAULT NULL
);

CREATE TABLE project_costoperatelog (
  autoid INT PRIMARY KEY AUTO_INCREMENT,
  recordid varchar(36) DEFAULT NULL,
  orderid varchar(36) DEFAULT NULL,
  price numeric(18,4) DEFAULT NULL,
  operatetype int DEFAULT NULL,
  remark text,
  createaccount varchar(36) DEFAULT NULL,
  projectid varchar(36) DEFAULT NULL,
  createtime timestamp without time zone DEFAULT NULL
);

CREATE TABLE project_transactionrecord (
  autoid INT PRIMARY KEY AUTO_INCREMENT,
  recordid varchar(36) DEFAULT NULL,
  orderid varchar(36) DEFAULT NULL,
  appid varchar(36) DEFAULT NULL,
  recordtype int DEFAULT NULL,
  status int DEFAULT NULL,
  price numeric(18,4) DEFAULT NULL,
  remark text,
  createaccount varchar(36) DEFAULT NULL,
  payaccount varchar(36) DEFAULT NULL,
  projectid varchar(36) DEFAULT NULL,
  createtime timestamp without time zone DEFAULT NULL,
  customoverduetime timestamp without time zone DEFAULT NULL,
  updatetime timestamp without time zone DEFAULT NULL,
  recordtypetitle varchar(128) DEFAULT NULL,
  extendid varchar(128) DEFAULT NULL
);