CREATE OR REPLACE FUNCTION last_insert_id(my_table_name text,my_primary_key_column text)
  RETURNS INTEGER AS $$
DECLARE
    last_id INTEGER;
    tablename text;
    columnname text;
BEGIN
   tablename := LOWER(my_table_name);
   columnname := LOWER(my_primary_key_column);

    SELECT currval(pg_get_serial_sequence(tablename, columnname)) INTO last_id;
    RETURN last_id;
END;
$$ LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION IFNULL(invalue1 anyelement, invalue2 anyelement)
  RETURNS anyelement AS $BODY$
begin
   if inValue1 is null then
       return inValue2;
   else
       return inValue1;
   end if;
end;
$BODY$
LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION IFNULL(invalue1 bigint, invalue2 integer)
  RETURNS integer AS $BODY$
begin
   if inValue1 is null then
       return inValue2;
   else
       return inValue1;
   end if;
end;
$BODY$
LANGUAGE plpgsql;

create cast(text as oid) with inout as implicit;

UPDATE pg_cast SET castcontext = 'i' WHERE castsource = 16 AND casttarget = 23;