\c MDProject

CREATE TABLE "Account" (
  "AutoId" serial PRIMARY KEY,
  "AccountId" varchar(36) NOT NULL,
  "MobilePhone" varchar(32) DEFAULT NULL,
  "Email" varchar(128) DEFAULT NULL,
  "Password" varchar(64) DEFAULT NULL,
  "CreateTime" timestamp DEFAULT NULL,
  "UpdateTime" timestamp DEFAULT NULL,
  "Status" int DEFAULT NULL,
  "SourceType" int DEFAULT NULL
);

CREATE TABLE "Account_Authentication" (
  "AutoId" serial PRIMARY KEY,
  "SourceId" varchar(128) DEFAULT NULL,
  "AuthType" int DEFAULT NULL,
  "AccountId" varchar(36) DEFAULT NULL,
  "Account" varchar(128) DEFAULT NULL,
  "Token" varchar(256) DEFAULT NULL,
  "Status" int DEFAULT NULL,
  "Number" int DEFAULT NULL,
  "ProjectId" varchar(36) DEFAULT NULL,
  "CreateAccountId" varchar(36) DEFAULT NULL,
  "CreateTime" timestamp DEFAULT NULL,
  "UpdateTime" timestamp DEFAULT NULL,
  "VerifyCode" varchar(10) DEFAULT NULL,
  "LastModifyAccountId" varchar(36) DEFAULT NULL
);

CREATE TABLE "Account_Bind_Email" (
  "AutoId" serial PRIMARY KEY,
  "AccountId" varchar(36) DEFAULT NULL,
  "Email" varchar(50) DEFAULT NULL,
  "ProjectId" varchar(36) DEFAULT NULL,
  "CreateTime" timestamp DEFAULT NULL,
  "UserId" varchar(36) DEFAULT NULL,
  "IsVerify" int DEFAULT NULL,
  "State" int DEFAULT NULL
);

CREATE TABLE "Account_Detail" (
  "AutoId" serial PRIMARY KEY,
  "AccountId" varchar(36) DEFAULT NULL,
  "Name" varchar(128) DEFAULT NULL,
  "Title" varchar(128) DEFAULT NULL,
  "Description" varchar(512) DEFAULT NULL,
  "StartDate" varchar(10) DEFAULT NULL,
  "EndDate" varchar(10) DEFAULT NULL,
  "DetailType" int DEFAULT NULL,
  "CreateTime" timestamp DEFAULT NULL,
  "UpdateTime" timestamp DEFAULT NULL
);

CREATE TABLE "Account_Friends" (
  "AutoId" serial PRIMARY KEY,
  "AccountIdA" varchar(36) DEFAULT NULL,
  "AccountIdB" varchar(36) DEFAULT NULL,
  "Status" int DEFAULT NULL,
  "Message" varchar(100) DEFAULT NULL,
  "CreateAccountId" varchar(36) DEFAULT NULL,
  "CreateTime" timestamp DEFAULT NULL,
  "UpdateTime" timestamp DEFAULT NULL
);

CREATE TABLE "Account_Medal" (
  "AutoId" serial PRIMARY KEY,
  "MedalId" varchar(36) NOT NULL,
  "ProjectId" varchar(36) DEFAULT NULL,
  "IsSystem" boolean DEFAULT NULL,
  "MedalName" varchar(512) DEFAULT NULL,
  "MedalType" int DEFAULT NULL,
  "SysMedalType" int DEFAULT NULL,
  "Description" varchar(1024) DEFAULT NULL,
  "IsEnable" boolean DEFAULT NULL,
  "Remark" varchar(1024) DEFAULT NULL,
  "LargePath" varchar(512) DEFAULT NULL,
  "MiddlePath" varchar(512) DEFAULT NULL,
  "SmallPath" varchar(512) DEFAULT NULL,
  "CreateAccount" varchar(36) DEFAULT NULL,
  "CreateTime" timestamp DEFAULT NULL,
  "UpdateTime" timestamp DEFAULT NULL
);

CREATE TABLE "Account_MedalGrantLog" (
  "AutoId" serial PRIMARY KEY,
  "GrantId" varchar(36) NOT NULL,
  "MedalId" varchar(36) DEFAULT NULL,
  "ProjectId" varchar(36) DEFAULT NULL,
  "FromId" varchar(36) DEFAULT NULL,
  "ToAccountId" varchar(36) DEFAULT NULL,
  "Remark" varchar(1024) DEFAULT NULL,
  "IsShow" boolean DEFAULT NULL,
  "IsGet" boolean DEFAULT NULL,
  "CreateTime" timestamp DEFAULT NULL,
  "UpdateTime" timestamp DEFAULT NULL
);

CREATE TABLE "Account_Scale" (
  "AutoID" serial PRIMARY KEY,
  "AccountId" varchar(36) DEFAULT NULL,
  "Type" int DEFAULT NULL,
  "CreateTime" timestamp DEFAULT NULL
);

CREATE TABLE "Account_Setting" (
  "AutoId" serial PRIMARY KEY,
  "AccountId" varchar(36) DEFAULT NULL,
  "SettingName" varchar(64) DEFAULT NULL,
  "SettingValue" varchar(512) DEFAULT NULL,
  "CreateTime" timestamp DEFAULT NULL,
  "UpdateTime" timestamp DEFAULT NULL
);

CREATE TABLE "AccountExpand" (
  "AutoId" serial PRIMARY KEY,
  "AccountId" varchar(36) NOT NULL,
  "Mark" int DEFAULT NULL,
  "LeftMark" int DEFAULT NULL,
  "Num_Login" int DEFAULT NULL,
  "Num_View" int DEFAULT NULL,
  "Num_Post" int DEFAULT NULL,
  "Num_Comment" int DEFAULT NULL,
  "LastLoginTime" timestamp DEFAULT NULL,
  "CurrentLoginTime" timestamp DEFAULT NULL
);

CREATE TABLE "AccountInfo" (
  "AutoId" serial PRIMARY KEY,
  "AccountId" varchar(36) NOT NULL,
  "CompanyName" varchar(128) DEFAULT NULL,
  "Profession" varchar(128) DEFAULT NULL,
  "Avatar" varchar(128) DEFAULT NULL,
  "Fullname" varchar(128) DEFAULT NULL,
  "Gender" int DEFAULT NULL,
  "Birthdate" date DEFAULT NULL,
  "IM_QQ" varchar(16) DEFAULT NULL,
  "SNS_Sina" varchar(128) DEFAULT NULL,
  "SNS_QQ" varchar(128) DEFAULT NULL,
  "SNS_Linkedin" varchar(128) DEFAULT NULL,
  "WeiXin" varchar(128) DEFAULT NULL,
  "AppId" varchar(36) DEFAULT NULL,
  "CreateTime" timestamp DEFAULT NULL,
  "FirstCode" varchar(2) DEFAULT NULL,
  "Address" varchar(500) DEFAULT NULL,
  "ContactMobilePhone" varchar(32) DEFAULT NULL,
  "UpdateTime" timestamp DEFAULT NULL
);

CREATE TABLE "AccountStatistic" (
  "AutoId" serial PRIMARY KEY,
  "AccountID" varchar(36) NOT NULL,
  "CompanyName" varchar(128) DEFAULT NULL,
  "Fullname" varchar(128) DEFAULT NULL,
  "Gender" int DEFAULT NULL,
  "Birthdate" timestamp DEFAULT NULL,
  "IM_QQ" varchar(16) DEFAULT NULL,
  "MobilePhone" varchar(32) DEFAULT NULL,
  "Email" varchar(128) DEFAULT NULL,
  "Status" int DEFAULT NULL,
  "SNS_Sina" varchar(128) DEFAULT NULL,
  "SNS_QQ" varchar(128) DEFAULT NULL,
  "SNS_Linkedin" varchar(128) DEFAULT NULL,
  "WeiXin" varchar(128) DEFAULT NULL,
  "CreateTime" timestamp DEFAULT NULL,
  "AppId" varchar(36) DEFAULT NULL,
  "FromRegister" varchar(100) DEFAULT NULL,
  "Num_Login" int DEFAULT NULL,
  "Num_View" int DEFAULT NULL,
  "Num_Post" int DEFAULT NULL,
  "Num_Comment" int DEFAULT NULL,
  "Num_Task" int DEFAULT NULL,
  "Num_TaskComment" int DEFAULT NULL,
  "Num_CreateCalendar" int DEFAULT NULL,
  "Num_ParticipateCalendar" int DEFAULT NULL,
  "Num_File" int DEFAULT NULL,
  "Num_Image" int DEFAULT NULL,
  "Num_Voice" int DEFAULT NULL,
  "Num_Video" int DEFAULT NULL,
  "VIPEndDate" timestamp DEFAULT NULL,
  "LastLoginTime" timestamp DEFAULT NULL,
  "NowMonthFlow" int DEFAULT NULL,
  "FlowResetDay" int DEFAULT NULL,
  "StorageSpace" int DEFAULT NULL,
  "Num_Invite" int DEFAULT NULL,
  "Num_Project" int DEFAULT NULL,
  "Avatar" varchar(128) DEFAULT NULL,
  "UpdateTime" timestamp DEFAULT NULL
);

CREATE TABLE "Project" (
  "AutoID" serial PRIMARY KEY,
  "ProjectID" varchar(36) NOT NULL,
  "CompanyName" varchar(128) DEFAULT NULL,
  "CompanyNameEn" varchar(256) DEFAULT NULL,
  "CompanyDisplayName" varchar(128) DEFAULT NULL,
  "Status" int DEFAULT NULL,
  "GeographyID" int DEFAULT NULL,
  "IndustryID" int DEFAULT NULL,
  "Balance" numeric(18,4) DEFAULT NULL,
  "CreateUser" varchar(36) DEFAULT NULL,
  "LastModifyUser" varchar(36) DEFAULT NULL,
  "ParentID" varchar(36) DEFAULT NULL,
  "CreateTime" timestamp DEFAULT NULL,
  "UpdateTime" timestamp DEFAULT NULL
);

CREATE TABLE "Project_Department"(
  "AutoID"          serial PRIMARY KEY,
  "DepartmentID"    varchar(36) NOT NULL,
  "DepartmentName"  varchar(128)      DEFAULT NULL,
  "CreateUser"      varchar(36)          DEFAULT NULL,
  "LastModifyUser"  varchar(36)          DEFAULT NULL,
  "ProjectID"       varchar(36)          DEFAULT NULL,
  "MappingGroupID"  varchar(36)          DEFAULT NULL,
  "CreateTime"      timestamp DEFAULT NULL,
  "UpdateTime"      timestamp DEFAULT NULL,
  "ParentId"        varchar(36)          DEFAULT NULL,
  "ChargeAccountId" varchar(1024)     DEFAULT NULL,
  "SortIndex"       bigint NOT NULL DEFAULT 0,
  "Deleted"         boolean   NOT NULL DEFAULT false,
  "Disabled"        boolean   NOT NULL DEFAULT false
);

CREATE TABLE "Project_DepartmentAccount" (
  "AutoId" serial PRIMARY KEY,
  "ProjectId" varchar(36) NOT NULL,
  "DepartmentId" varchar(36) NOT NULL,
  "AccountId" varchar(36) NOT NULL,
  "IsMainDepartment" boolean NOT NULL DEFAULT false,
  "IsManager" boolean NOT NULL DEFAULT false,
  "CreateTime" timestamp NOT NULL,
  "CreateUser" varchar(36) DEFAULT NULL,
  "UpdateTime" timestamp NOT NULL,
  "LastModifyUser" varchar(36) DEFAULT NULL,
  "Deleted" boolean NOT NULL DEFAULT false,
  "DisplayOrder" int NOT NULL DEFAULT 0
);

CREATE TABLE "Project_JobAccount" (
  "AutoId" serial PRIMARY KEY,
  "ProjectId" varchar(36) NOT NULL,
  "JobId" varchar(36) NOT NULL,
  "AccountId" varchar(36) NOT NULL,
  "CreateUser" varchar(36) DEFAULT NULL,
  "CreateTime" timestamp NOT NULL,
  "UpdateTime" timestamp NOT NULL,
  "LastModifyUser" varchar(36) DEFAULT NULL,
  "DepartmentId" varchar(36) DEFAULT NULL
);

CREATE TABLE "Project_Finance" (
  "AutoID" serial PRIMARY KEY,
  "ProjectID" varchar(36) NOT NULL,
  "Address" varchar(256) DEFAULT NULL,
  "RecipientName" varchar(64) DEFAULT NULL,
  "Postcode" varchar(16) DEFAULT NULL,
  "MobilePhone" varchar(32) DEFAULT NULL,
  "ContactPhone" varchar(32) DEFAULT NULL,
  "Fax" varchar(32) DEFAULT NULL,
  "Email" varchar(128) DEFAULT NULL,
  "EmailRecipientName" varchar(64) DEFAULT NULL,
  "InvoiceType" int DEFAULT NULL,
  "TaxNumber" varchar(64) DEFAULT NULL,
  "TaxBank" varchar(128) DEFAULT NULL,
  "TaxBankNumber" varchar(64) DEFAULT NULL,
  "TaxRegAddress" varchar(256) DEFAULT NULL,
  "TaxRegContactPhone" varchar(32) DEFAULT NULL,
  "IsGeneralTaxpayer" boolean DEFAULT NULL,
  "CreateUser" varchar(36) DEFAULT NULL,
  "LastModifyUser" varchar(36) DEFAULT NULL,
  "CreateTime" timestamp DEFAULT NULL,
  "UpdateTime" timestamp DEFAULT NULL
);

CREATE TABLE "Project_Job" (
  "AutoID" serial PRIMARY KEY,
  "JobID" varchar(36) NOT NULL,
  "JobName" varchar(128) DEFAULT NULL,
  "CreateUser" varchar(36) DEFAULT NULL,
  "LastModifyUser" varchar(36) DEFAULT NULL,
  "ProjectID" varchar(36) DEFAULT NULL,
  "CreateTime" timestamp DEFAULT NULL,
  "UpdateTime" timestamp DEFAULT NULL
);

CREATE TABLE "Project_Setting" (
  "AutoID" serial PRIMARY KEY,
  "ProjectID" varchar(36) DEFAULT NULL,
  "SettingName" varchar(64) DEFAULT NULL,
  "SettingValue" varchar(255) DEFAULT NULL,
  "CreateUser" varchar(36) DEFAULT NULL,
  "LastModifyUser" varchar(36) DEFAULT NULL,
  "CreateTime" timestamp DEFAULT NULL,
  "UpdateTime" timestamp DEFAULT NULL
);

CREATE TABLE "Project_Source" (
  "AutoID" serial PRIMARY KEY,
  "Source" int DEFAULT NULL,
  "CreateUser" varchar(36) DEFAULT NULL,
  "ProjectID" varchar(36) DEFAULT NULL,
  "CreateTime" timestamp DEFAULT NULL
);

CREATE TABLE "Project_WorkSite" (
  "AutoID" serial PRIMARY KEY,
  "WorkSiteID" varchar(36) NOT NULL,
  "WorkSiteName" varchar(128) DEFAULT NULL,
  "CreateUser" varchar(36) DEFAULT NULL,
  "LastModifyUser" varchar(36) DEFAULT NULL,
  "ProjectID" varchar(36) DEFAULT NULL,
  "CreateTime" timestamp DEFAULT NULL,
  "UpdateTime" timestamp DEFAULT NULL
);

CREATE TABLE "ProjectAuthorization" (
  "AutoId" serial PRIMARY KEY,
  "ProjectId" varchar(36) DEFAULT NULL,
  "AppKey" varchar(100) DEFAULT NULL,
  "SecretKey" varchar(100) DEFAULT NULL,
  "ExpireTime" timestamp DEFAULT NULL,
  "Type" int DEFAULT NULL,
  "CreateTime" timestamp DEFAULT NULL,
  "CreateAccountId" varchar(36) DEFAULT NULL,
  "Status" int DEFAULT NULL,
  "Sign" varchar(512) DEFAULT NULL
);

CREATE TABLE "RoutingAccount" (
  "AutoID" serial PRIMARY KEY,
  "AccountId" varchar(36) DEFAULT NULL,
  "UserID" varchar(36) DEFAULT NULL,
  "ProjectID" varchar(36) DEFAULT NULL,
  "Status" int DEFAULT NULL,
  "ServerID" varchar(36) DEFAULT NULL,
  "CreateTime" timestamp DEFAULT NULL,
  "UpdateTime" timestamp DEFAULT NULL,
  "CompanyName" varchar(128) DEFAULT NULL,
  "UserType" int DEFAULT NULL
);

CREATE TABLE "RoutingProject" (
  "AutoID" serial PRIMARY KEY,
  "ProjectID" varchar(36) NOT NULL,
  "ParentID" varchar(36) DEFAULT NULL,
  "ServerID" varchar(36) DEFAULT NULL,
  "CompanyName" varchar(128) DEFAULT NULL,
  "SubDomain" varchar(64) DEFAULT NULL,
  "BaseAuthenticationDomain" varchar(128) DEFAULT NULL,
  "ExpandAuthenticationDomain" varchar(512) DEFAULT NULL,
  "CreateTime" timestamp DEFAULT NULL,
  "UpdateTime" timestamp DEFAULT NULL
);

CREATE TABLE "RoutingProjectExpand" (
  "AutoID" serial PRIMARY KEY,
  "ProjectID" varchar(36) NOT NULL,
  "CompanyName" varchar(128) DEFAULT NULL,
  "IsEMail" boolean DEFAULT NULL,
  "PaidType" int DEFAULT NULL,
  "Geography" int DEFAULT NULL,
  "Industry" int DEFAULT NULL,
  "Num_User" int DEFAULT NULL,
  "Num_Group" int DEFAULT NULL,
  "Num_Post" int DEFAULT NULL,
  "Num_Comment" int DEFAULT NULL,
  "Num_Pic" int DEFAULT NULL,
  "Num_Doc" int DEFAULT NULL,
  "Num_QA" int DEFAULT NULL,
  "Num_Task" int DEFAULT NULL,
  "Num_Sms" int DEFAULT NULL,
  "Filesize_Pic" numeric(20,3) DEFAULT NULL,
  "Filesize_Doc" numeric(20,3) DEFAULT NULL,
  "LoginCountByLastWeek" int DEFAULT NULL,
  "PostCountByLastWeek" int DEFAULT NULL,
  "CommentCountByLastWeek" int DEFAULT NULL,
  "LastLoginTime" timestamp DEFAULT NULL,
  "InvoiceType" int DEFAULT NULL,
  "CreateUser" varchar(36) DEFAULT NULL,
  "CreateTime" timestamp DEFAULT NULL,
  "UpdateTime" timestamp DEFAULT NULL,
  "Vitality" numeric(18,0) DEFAULT NULL,
  "Num_Calander" int DEFAULT NULL,
  "Num_Voice" int DEFAULT NULL,
  "Num_Video" int DEFAULT NULL,
  "Num_TaskReply" int DEFAULT NULL,
  "Num_Login" int DEFAULT NULL
);

CREATE TABLE "RoutingProjectExpandForOther" (
  "AutoID" serial PRIMARY KEY,
  "ProjectID" varchar(36) NOT NULL,
  "Balance" numeric(10,2) DEFAULT NULL,
  "PayStatus" int DEFAULT NULL,
  "UpdateTime" timestamp DEFAULT NULL
);

CREATE TABLE "RoutingUserExpand" (
  "AutoID" serial PRIMARY KEY,
  "UserID" varchar(36) DEFAULT NULL,
  "ProjectID" varchar(36) DEFAULT NULL,
  "CompanyName" varchar(128) DEFAULT NULL,
  "Num_ProjectUsers" int DEFAULT NULL,
  "Email" varchar(128) DEFAULT NULL,
  "Status" int DEFAULT NULL,
  "IsAdmin" int DEFAULT NULL,
  "UserType" int DEFAULT NULL,
  "Fullname" varchar(128) DEFAULT NULL,
  "Mark" int DEFAULT NULL,
  "LastMark" int DEFAULT NULL,
  "Grade" varchar(64) DEFAULT NULL,
  "Avatar" varchar(128) DEFAULT NULL,
  "Gender" int DEFAULT NULL,
  "Birthdate" date DEFAULT NULL,
  "Job" varchar(64) DEFAULT NULL,
  "Department" varchar(64) DEFAULT NULL,
  "City" varchar(64) DEFAULT NULL,
  "MobilePhone" varchar(32) DEFAULT NULL,
  "ContactPhone" varchar(32) DEFAULT NULL,
  "Num_Login" int DEFAULT NULL,
  "Num_View" int DEFAULT NULL,
  "Num_Follower" int DEFAULT NULL,
  "Num_Concern" int DEFAULT NULL,
  "Num_Post" int DEFAULT NULL,
  "Num_Comment" int DEFAULT NULL,
  "LastLoginTime" timestamp DEFAULT NULL,
  "CreateTime" timestamp DEFAULT NULL,
  "UpdateTime" timestamp DEFAULT NULL,
  "AccountID" varchar(36) DEFAULT NULL,
  "DepartmentId" varchar(36) DEFAULT NULL,
  "JobId" varchar(36) DEFAULT NULL
);

CREATE TABLE "FixedData" (
  "AutoID" serial PRIMARY KEY,
  "DataID" int DEFAULT NULL,
  "DataName" varchar(128) DEFAULT NULL,
  "ParentDataID" int DEFAULT NULL,
  "DataType" int DEFAULT NULL
);

CREATE TABLE "ImportUserInfo" (
  "AutoId" serial PRIMARY KEY,
  "ProjectID" varchar(36) DEFAULT NULL,
  "Status" int DEFAULT NULL,
  "Fullname" varchar(100) DEFAULT NULL,
  "Account" varchar(100) DEFAULT NULL,
  "Department" varchar(100) DEFAULT NULL,
  "Job" varchar(100) DEFAULT NULL,
  "CompanyName" varchar(100) DEFAULT NULL,
  "WorkSite" varchar(100) DEFAULT NULL,
  "JobNumber" varchar(100) DEFAULT NULL,
  "ContactPhone" varchar(100) DEFAULT NULL,
  "CreateAccountId" varchar(36) DEFAULT NULL,
  "CreateTime" timestamp DEFAULT NULL,
  "UpdateTime" timestamp DEFAULT NULL,
  "DepartmentId" varchar(36) DEFAULT NULL,
  "AccountId" varchar(36) DEFAULT NULL,
  "WorkSiteId" varchar(36) DEFAULT NULL,
  "JobId" varchar(36) DEFAULT NULL,
  "DepartmentIds" varchar(1000) DEFAULT NULL,
  "JobIds" varchar(1000) DEFAULT NULL,
  "OrgRoleIds" varchar(1000) DEFAULT NULL,
  "UseMultiJobs" boolean DEFAULT false NOT NULL,
  "DepartmentJobIdMaps" varchar(2000) DEFAULT NULL
);

CREATE TABLE "LinkAuthentication" (
  "AutoId" serial PRIMARY KEY,
  "SourceId" varchar(128) DEFAULT NULL,
  "InviteFromType" int DEFAULT NULL,
  "Token" varchar(255) DEFAULT NULL,
  "ProjectId" varchar(36) DEFAULT NULL,
  "CreateAccountId" varchar(36) DEFAULT NULL,
  "LinkFromType" int DEFAULT NULL,
  "DeadTime" timestamp DEFAULT NULL,
  "CreateTime" timestamp DEFAULT NULL,
  "UpdateTime" timestamp DEFAULT NULL
);

CREATE TABLE "UsersCard" (
  "AutoId" serial PRIMARY KEY,
  "UserId" varchar(36) NOT NULL,
  "AccountId" varchar(36) DEFAULT NULL,
  "ProjectId" varchar(36) DEFAULT NULL,
  "CompanyName" varchar(128) DEFAULT NULL,
  "Fullname" varchar(128) DEFAULT NULL,
  "Job" varchar(64) DEFAULT NULL,
  "Department" varchar(128) DEFAULT NULL,
  "ContactPhone" varchar(32) DEFAULT NULL,
  "WorkSite" varchar(128) DEFAULT NULL,
  "JobNumber" varchar(128) DEFAULT NULL,
  "Status" int DEFAULT NULL,
  "LastModifyUser" varchar(36) DEFAULT NULL,
  "CreateTime" timestamp DEFAULT NULL,
  "UpdateTime" timestamp DEFAULT NULL,
  "DepartmentId" varchar(36) DEFAULT NULL,
  "WorkSiteId" varchar(36) DEFAULT NULL,
  "JobId" varchar(36) DEFAULT NULL,
  "UseMultiJobs" boolean DEFAULT false NOT NULL
);

CREATE TABLE "Role" (
  "AutoId" serial PRIMARY KEY,
  "ProjectId" varchar(50) DEFAULT NULL,
  "RoleId" varchar(50) DEFAULT NULL,
  "RoleName" varchar(50) DEFAULT NULL,
  "CreateUser" varchar(50) DEFAULT NULL,
  "CreateTime" timestamp DEFAULT NULL,
  "LastModifyUser" varchar(50) DEFAULT NULL,
  "UpdateTime" timestamp DEFAULT NULL,
  "IsDelete" boolean DEFAULT NULL,
  "EntityId" varchar(50) DEFAULT NULL,
  "EntityType" int DEFAULT NULL,
  "RoleType" int DEFAULT NULL
);

CREATE TABLE "RolePermission" (
  "AutoId" serial PRIMARY KEY,
  "ProjectId" varchar(50) DEFAULT NULL,
  "RoleId" varchar(50) DEFAULT NULL,
  "PermissionId" int DEFAULT NULL,
  "CreateUser" varchar(50) DEFAULT NULL,
  "CreateTime" timestamp DEFAULT NULL,
  "LastModifyUser" varchar(50) DEFAULT NULL,
  "UpdateTime" timestamp DEFAULT NULL,
  "EntityId" varchar(50) DEFAULT NULL,
  "EntityType" int DEFAULT NULL
);

CREATE TABLE "Permission" (
  "AutoId" serial PRIMARY KEY,
  "TypeId" int DEFAULT NULL,
  "TypeName" varchar(100) DEFAULT NULL,
  "PermissionId" int DEFAULT NULL,
  "PermissionName" varchar(100) DEFAULT NULL,
  "IsTypeAdmin" boolean DEFAULT NULL,
  "Description" varchar(200) DEFAULT NULL,
  "ParentId" int DEFAULT NULL,
  "OrderId" int DEFAULT NULL,
  "EntityType" int DEFAULT NULL,
  "HasChild" boolean DEFAULT NULL
);

CREATE TABLE "UserRole" (
  "AutoId" serial PRIMARY KEY,
  "AccountId" varchar(50) DEFAULT NULL,
  "ProjectId" varchar(50) DEFAULT NULL,
  "RoleId" varchar(50) DEFAULT NULL,
  "Status" int DEFAULT NULL,
  "CreateUser" varchar(50) DEFAULT NULL,
  "CreateTime" timestamp DEFAULT NULL,
  "LastModifyUser" varchar(50) DEFAULT NULL,
  "UpdateTime" timestamp DEFAULT NULL,
  "UserScopeType" int DEFAULT NULL,
  "EntityId" varchar(50) DEFAULT NULL,
  "EntityType" int DEFAULT NULL,
  "OriginId" varchar(50) DEFAULT NULL,
  "OriginName" varchar(50) DEFAULT NULL,
  "OriginType" int DEFAULT NULL
);

CREATE TABLE "Project_UserRule" (
  "AutoId" serial PRIMARY KEY,
  "ProjectId" varchar(36) NOT NULL,
  "RuleId" varchar(36) NOT NULL,
  "CreateTime" timestamp NOT NULL,
  "CreateUser" varchar(36) NOT NULL,
  "UpdateTime" timestamp NOT NULL,
  "LastModifyUser" varchar(36) NOT NULL,
  "RuleType" int NOT NULL DEFAULT '10'
);

CREATE TABLE "Project_UserRuleItem" (
  "AutoId" serial PRIMARY KEY,
  "ProjectId" varchar(36) NOT NULL,
  "RuleId" varchar(36) NOT NULL,
  "RuleItemType" int NOT NULL DEFAULT '0',
  "TargetId" varchar(50) NOT NULL,
  "TargetType" int NOT NULL DEFAULT '0',
  "CreateTime" timestamp NOT NULL,
  "CreateUser" varchar(36) NOT NULL
);

CREATE TABLE "Project_Organize" (
  "AutoID" serial PRIMARY KEY,
  "OrganizeID" varchar(36) NOT NULL,
  "OrganizeGroupID" varchar(36) DEFAULT NULL,
  "OrganizeName" varchar(128) DEFAULT NULL,
  "ProjectID" varchar(36) NOT NULL,
  "Remark" text,
  "SortIndex" int NOT NULL,
  "CreateUser" varchar(36) DEFAULT NULL,
  "LastModifyUser" varchar(36) DEFAULT NULL,
  "CreateTime" timestamp DEFAULT NULL,
  "UpdateTime" timestamp DEFAULT NULL,
  "Disabled" boolean NOT NULL DEFAULT false
);

CREATE TABLE "Project_OrganizeAccount" (
  "AutoId" serial PRIMARY KEY,
  "ProjectId" varchar(36) NOT NULL,
  "OrganizeId" varchar(36) NOT NULL,
  "AccountId" varchar(36) NOT NULL,
  "CreateUser" varchar(36) DEFAULT NULL,
  "CreateTime" timestamp NOT NULL,
  "UpdateTime" timestamp NOT NULL,
  "LastModifyUser" varchar(36) DEFAULT NULL
);

CREATE TABLE "Project_OrgRoleChargeDepartment" (
    "AutoId" serial PRIMARY KEY,
    "ProjectId" varchar(36) NOT NULL,
    "OrgRoleId" varchar(36) NOT NULL,
    "AccountId" varchar(36) NOT NULL,
    "DepartmentId" varchar(36) NOT NULL,
    "IsIncludeSub" boolean NOT NULL DEFAULT true,
    "CreateUser" varchar(36) NOT NULL,
    "CreateTime" timestamp NOT NULL,
    "UpdateTime" timestamp NOT NULL,
    "LastModifyUser" varchar(36) NOT NULL
);

CREATE TABLE "Project_OrgRoleGroup" (
    "AutoID" serial PRIMARY KEY,
    "ProjectID" varchar(36) NOT NULL,
    "OrganizeGroupID" varchar(36) NOT NULL,
    "OrganizeGroupName" varchar(128),
    "SortIndex" int DEFAULT 0 NOT NULL,
    "CreateUser" varchar(36) NOT NULL,
    "LastModifyUser" varchar(36) NOT NULL,
    "CreateTime" timestamp NOT NULL,
    "UpdateTime" timestamp NOT NULL,
    "Disabled" boolean NOT NULL DEFAULT false
);

CREATE INDEX idx_account_aid ON Account USING btree (AccountId);
CREATE INDEX idx_amedal_mid ON Account_Medal USING btree (MedalId);
CREATE INDEX idx_amedal_gid ON Account_MedalGrantLog USING btree (GrantId);
CREATE INDEX idx_aexpand_aid ON AccountExpand USING btree (AccountId);
CREATE INDEX idx_ainfo_aid ON AccountInfo USING btree (AccountId);
CREATE INDEX idx_astatistic_aid ON AccountStatistic USING btree (AccountID);
CREATE INDEX idx_project_pid ON Project USING btree (ProjectID);
CREATE INDEX idx_pdept_pid_paid ON Project_Department USING btree (ProjectID,ParentId);
CREATE INDEX idx_pdept_did_pid ON Project_Department USING btree (DepartmentID,ProjectID);
CREATE INDEX idx_pda_pid_did_aid ON Project_DepartmentAccount USING btree (ProjectId,DepartmentId,AccountId);
CREATE INDEX idx_pda_pid_aid ON Project_DepartmentAccount USING btree (ProjectId,AccountId);
CREATE INDEX idx_pda_pid_did_ord ON Project_DepartmentAccount USING btree (ProjectId,DepartmentId,DisplayOrder);
CREATE INDEX idx_pja_pid_jid_aid ON Project_JobAccount USING btree (ProjectId,JobId,AccountId);
CREATE INDEX idx_pja_pid_aid ON Project_JobAccount USING btree (ProjectId,AccountId);
CREATE INDEX idx_pf_pid ON Project_Finance USING btree (ProjectID);
CREATE INDEX idx_pj_pid_jid ON Project_Job USING btree (ProjectID,JobID);
CREATE INDEX idx_pj_jid ON Project_Job USING btree (JobID);
CREATE INDEX idx_pw_pid_wid ON Project_WorkSite USING btree (ProjectID,WorkSiteID);
CREATE INDEX idx_pw_wid ON Project_WorkSite USING btree (WorkSiteID);
CREATE UNIQUE INDEX uidx_ra_pid_aid ON RoutingAccount USING btree (ProjectID,AccountId);
CREATE INDEX idx_ra_aid_pid ON RoutingAccount USING btree (AccountId,ProjectID);
CREATE INDEX idx_rp_pid ON RoutingProject USING btree (ProjectID);
CREATE INDEX idx_rpe_pid ON RoutingProjectExpand USING btree (ProjectID);
CREATE INDEX idx_rpefo_pid ON RoutingProjectExpandForOther USING btree (ProjectID);
CREATE UNIQUE INDEX uidx_ucard_pid_aid ON UsersCard USING btree (ProjectId,AccountId);
CREATE INDEX idx_ucard_aid_pid ON UsersCard USING btree (AccountId,ProjectId);
CREATE INDEX idx_role_pid_rid ON Role USING btree (ProjectId,RoleId);
CREATE INDEX idx_role_rid_eid_etype ON Role USING btree (RoleId,EntityId,EntityType);
CREATE INDEX idx_rp_pid_pmsid ON RolePermission USING btree (ProjectId,PermissionId);
CREATE INDEX idx_rp_pid_rid ON RolePermission USING btree (ProjectId,RoleId);
CREATE INDEX idx_rp_pid_eid_etype ON RolePermission USING btree (PermissionId,EntityId,EntityType);
CREATE INDEX idx_rp_rid_eid_etype ON RolePermission USING btree (RoleId,EntityId,EntityType);
CREATE INDEX idx_perm_pid_etype ON Permission USING btree (PermissionId,EntityType);
CREATE INDEX idx_ur_aid_pid ON UserRole USING btree (AccountId,ProjectId);
CREATE INDEX idx_ur_pid_rid ON UserRole USING btree (ProjectId,RoleId);
CREATE INDEX idx_ur_etype_eid_aid ON UserRole USING btree (EntityType,EntityId,AccountId);
CREATE INDEX idx_ur_etype_eid_rid ON UserRole USING btree (EntityType,EntityId,RoleId);
CREATE INDEX idx_pur_pid ON Project_UserRule USING btree (ProjectId);
CREATE INDEX idx_pur_rid ON Project_UserRule USING btree (RuleId);
CREATE INDEX idx_puri_pid_rid ON Project_UserRuleItem USING btree (ProjectId,RuleId);
CREATE INDEX idx_po_pid_oid ON Project_Organize USING btree (ProjectID,OrganizeID);
CREATE INDEX idx_poa_pid_oid_aid ON Project_OrganizeAccount USING btree (ProjectId,OrganizeId,AccountId);
CREATE INDEX idx_porcd_pid_orid_aid ON Project_OrgRoleChargeDepartment USING btree (ProjectId,OrgRoleId,AccountId);
CREATE INDEX idx_porg_pid ON Project_OrgRoleGroup USING btree (ProjectId);