\c MDApplication

CREATE TABLE "Account_Device" (
  "AutoId" serial PRIMARY KEY,
  "AccountID" varchar(64) DEFAULT NULL,
  "AppID" varchar(64) DEFAULT NULL,
  "Device" varchar(256) DEFAULT NULL,
  "DeviceType" int DEFAULT '0',
  "RegID" varchar(256) DEFAULT NULL,
  "NotifyType" int DEFAULT NULL,
  "OSType" varchar(128) DEFAULT NULL,
  "UpdateTime" timestamp DEFAULT NULL,
  "Language" varchar(50) DEFAULT NULL,
  "AppVersion" varchar(30) DEFAULT NULL,
  "Source" int DEFAULT NULL,
  "Channel" int DEFAULT NULL
);

CREATE TABLE "Application" (
  "AutoID" serial PRIMARY KEY,
  "AppID" varchar(64) NOT NULL,
  "AppName" varchar(256) DEFAULT NULL,
  "Avatar" varchar(128) DEFAULT NULL,
  "Summary" varchar(256) DEFAULT NULL,
  "About" varchar(1024) DEFAULT NULL,
  "IS_Personal" boolean DEFAULT NULL,
  "IS_Free" boolean DEFAULT NULL,
  "IS_Private" boolean DEFAULT false,
  "ProjectIDRange" varchar(1024) DEFAULT NULL,
  "ShowModel" int NOT NULL DEFAULT '0',
  "Pricing_Fee" numeric(10,2) DEFAULT '0.00',
  "Pricing_Unit" int DEFAULT '0',
  "Pricing_Time" int DEFAULT '0',
  "Pricing_Type" int DEFAULT '3',
  "Pricing_Mark" varchar(1024) DEFAULT NULL,
  "NoticeUrl" varchar(256) DEFAULT NULL,
  "AppUrl" varchar(128) DEFAULT NULL,
  "HomeUrl" varchar(128) DEFAULT NULL,
  "SettingUrl" varchar(128) DEFAULT NULL,
  "Consumer_Key" varchar(128) DEFAULT NULL,
  "Consumer_Secret" varchar(128) DEFAULT NULL,
  "Authorize_sign" int DEFAULT '0',
  "Authorize_lic" int DEFAULT '0',
  "Calback_Url" varchar(128) DEFAULT NULL,
  "Rating" numeric(8,2) DEFAULT NULL,
  "Num_User" int DEFAULT NULL,
  "Num_Post" int DEFAULT NULL,
  "ProjectID" varchar(64) DEFAULT NULL,
  "CreateUser" varchar(64) DEFAULT NULL,
  "LastModifyUser" varchar(64) DEFAULT NULL,
  "Status" int DEFAULT NULL,
  "Type" int DEFAULT NULL,
  "ReMark" varchar(512) DEFAULT NULL,
  "CategoryID" varchar(64) DEFAULT NULL,
  "GeoID" int NOT NULL DEFAULT '1',
  "DeviceField" varchar(512) DEFAULT NULL,
  "CreateTime" timestamp DEFAULT NULL,
  "UpdateTime" timestamp DEFAULT NULL,
  "PublicTime" timestamp DEFAULT NULL,
  "ApplyStatus" int DEFAULT NULL,
  "Is_Wap" boolean DEFAULT true,
  "SubscibeUrl" varchar(256) DEFAULT NULL,
  "AppCode" varchar(1024) DEFAULT NULL,
  "AppmdConnect" varchar(1024) DEFAULT NULL,
  "AppCompanyName" varchar(1024) DEFAULT NULL,
  "AppContact" varchar(1024) DEFAULT NULL,
  "URLScheme" varchar(1024) DEFAULT NULL,
  "AndroidSSO" boolean DEFAULT NULL,
  "IosSSO" boolean DEFAULT NULL,
  "AppEmail" varchar(1024) DEFAULT NULL,
  "H5Url" varchar(1024) DEFAULT NULL,
  "AccountID" varchar(64) DEFAULT NULL,
  "WebHookUrl" varchar(500) DEFAULT NULL,
  "Modules" varchar(100) DEFAULT NULL,
  "WebHookCode" varchar(20) DEFAULT NULL,
  "WebHookStatus" int DEFAULT '1'
);

CREATE TABLE "Application_Admin" (
  "AutoID" serial PRIMARY KEY,
  "AppID" varchar(64) NOT NULL,
  "UserID" varchar(64) DEFAULT NULL,
  "ProjectID" varchar(64) DEFAULT NULL,
  "CreateUser" varchar(64) DEFAULT NULL,
  "CreateTime" timestamp DEFAULT NULL,
  "AccountID" varchar(64) DEFAULT NULL,
  "CreateAccountID" varchar(64) DEFAULT NULL
);

CREATE TABLE "OAuth2_Access_Token" (
  "AutoId" serial PRIMARY KEY,
  "AccessToken" varchar(128) NOT NULL,
  "AccountID" varchar(128) NOT NULL,
  "AppID" varchar(128) NOT NULL,
  "ProjectID" varchar(128) DEFAULT NULL,
  "AccessTokenExpires" timestamp DEFAULT NULL,
  "RefreshToken" varchar(128) DEFAULT NULL,
  "RefreshTokenExpires" timestamp DEFAULT NULL,
  "CreateTime" timestamp DEFAULT NULL
);

CREATE TABLE "Project_Application" (
  "AutoID" serial PRIMARY KEY,
  "ProjectID" varchar(64) DEFAULT NULL,
  "AppID" varchar(64) DEFAULT NULL,
  "AppCustomName" varchar(128) DEFAULT NULL,
  "GroupID" varchar(1024) DEFAULT NULL,
  "Rating" int DEFAULT NULL,
  "Status" int DEFAULT NULL,
  "CreateTime" timestamp DEFAULT NOW(),
  "UpdateTime" timestamp DEFAULT NOW()
);

CREATE TABLE "User_Application" (
  "AutoID" serial PRIMARY KEY,
  "UserID" varchar(64) DEFAULT NULL,
  "AppID" varchar(64) DEFAULT NULL,
  "DeviceMark" varchar(128) DEFAULT NULL,
  "Rating" int DEFAULT NULL,
  "Status" int DEFAULT NULL,
  "CreateTime" timestamp DEFAULT NULL,
  "UpdateTime" timestamp DEFAULT NULL,
  "DeviceType" int NOT NULL DEFAULT '0',
  "RegID" varchar(128) DEFAULT NULL,
  "ProjectID" varchar(64) DEFAULT NULL,
  "AccountID" varchar(64) DEFAULT NULL
);

CREATE TABLE "User_Application_Order" (
  "AutoID" serial PRIMARY KEY,
  "UserID" varchar(64) NOT NULL,
  "AppID" varchar(64) NOT NULL,
  "DisplayOrder" int NOT NULL,
  "CreateTime" timestamp NOT NULL,
  "IsTop" boolean DEFAULT NULL,
  "TopOrder" int DEFAULT NULL,
  "AccountID" varchar(64) DEFAULT NULL,
  "ProjectID" varchar(64) DEFAULT NULL
);

CREATE INDEX idx_device ON Account_Device USING btree (Device);
CREATE UNIQUE INDEX uk_app_appid ON Application USING btree (AppID);
CREATE INDEX idx_app_ck ON Application USING btree (Consumer_Key);
CREATE INDEX idx_app_admin_pid_appid ON Application_Admin USING btree (ProjectID,AppID);
CREATE INDEX idx_oat_at ON OAuth2_Access_Token USING btree (AccessToken);
CREATE INDEX idx_oat_rt ON OAuth2_Access_Token USING btree (RefreshToken);
CREATE INDEX idx_oat_aid_appid ON OAuth2_Access_Token USING btree (AccountID,AppID);
CREATE INDEX idx_app_pid_appid ON Project_Application USING btree (ProjectID,AppID);
CREATE INDEX idx_user_app_aid_appid ON User_Application USING btree (AccountID,AppID);
CREATE INDEX idx_user_app_order_aid ON User_Application_Order USING btree (AccountID);