\c MDCalendar

CREATE TABLE "Calendar" (
  "AutoID" serial PRIMARY KEY,
  "CalendarID" varchar(64) NOT NULL,
  "CalendarName" varchar(512) DEFAULT NULL,
  "StartTime" timestamp DEFAULT NULL,
  "EndTime" timestamp DEFAULT NULL,
  "IsAllDay" boolean DEFAULT NULL,
  "Address" varchar(512) DEFAULT NULL,
  "Description" varchar(1024) DEFAULT NULL,
  "Types" int DEFAULT NULL,
  "GroupID" varchar(512) DEFAULT NULL,
  "ProjectID" varchar(64) DEFAULT NULL,
  "Sequence" int DEFAULT '0',
  "IsRecur" boolean DEFAULT false,
  "Frequency" int DEFAULT '0',
  "Interval" int DEFAULT '1',
  "RecurCount" int DEFAULT '0',
  "UntilDate" timestamp DEFAULT NULL,
  "WeekDay" int DEFAULT NULL,
  "EventStart" timestamp DEFAULT NULL,
  "EventEnd" timestamp DEFAULT NULL,
  "CreateUser" varchar(64) DEFAULT NULL,
  "AppID" varchar(64) DEFAULT NULL,
  "IsDelete" boolean DEFAULT false,
  "CreateTime" timestamp DEFAULT NULL,
  "UpdateTime" timestamp DEFAULT NULL,
  "Locked" boolean DEFAULT NULL,
  "CreateAccountID" varchar(64) DEFAULT NULL,
  "IsPrivate" boolean NOT NULL DEFAULT false
);

CREATE TABLE "Calendar_Category" (
  "AutoID" serial PRIMARY KEY,
  "CatID" varchar(64) NOT NULL,
  "UserID" varchar(64) DEFAULT NULL,
  "Color" int DEFAULT NULL,
  "CatName" varchar(400) DEFAULT NULL,
  "ProjectID" varchar(64) DEFAULT NULL,
  "CreateTime" timestamp DEFAULT NULL,
  "AccountID" varchar(64) DEFAULT NULL
);

CREATE TABLE "Calendar_Member" (
  "AutoID" serial PRIMARY KEY,
  "CalendarID" varchar(64) NOT NULL,
  "UserID" varchar(64) DEFAULT NULL,
  "Email" varchar(128) DEFAULT NULL,
  "MobilePhone" varchar(32) DEFAULT NULL,
  "CatID" varchar(128) DEFAULT NULL,
  "GroupID" varchar(64) DEFAULT NULL,
  "Types" int DEFAULT NULL,
  "Status" int DEFAULT NULL,
  "ReMark" varchar(1024) DEFAULT NULL,
  "CreateTime" timestamp DEFAULT NULL,
  "RemindTime" int DEFAULT NULL,
  "RemindType" int DEFAULT NULL,
  "UpdateTime" timestamp DEFAULT NULL,
  "AccountID" varchar(64) DEFAULT NULL,
  "ProjectID" varchar(64) DEFAULT NULL,
  "VoiceRemind" boolean DEFAULT false
);

CREATE TABLE "ChildCalendarRecurTime" (
  "AutoID" serial PRIMARY KEY,
  "CalendarID" varchar(64) NOT NULL,
  "RecurTime" timestamp NOT NULL,
  "StartTime" timestamp NOT NULL,
  "Status" int DEFAULT NULL,
  "CalendarName" varchar(512) DEFAULT NULL,
  "EndTime" timestamp DEFAULT NULL,
  "IsAllDay" boolean DEFAULT NULL,
  "Address" varchar(512) DEFAULT NULL,
  "Description" varchar(1024) DEFAULT NULL,
  "Types" int DEFAULT NULL,
  "GroupID" varchar(512) DEFAULT NULL,
  "Sequence" int DEFAULT NULL,
  "CreateTime" timestamp DEFAULT NULL,
  "UpdateTime" timestamp DEFAULT NULL,
  "CreateUser" varchar(64) DEFAULT NULL,
  "Locked" boolean DEFAULT NULL,
  "ProjectID" varchar(64) DEFAULT NULL,
  "CreateAccountID" varchar(64) DEFAULT NULL,
  "IsPrivate" boolean NOT NULL DEFAULT false
); 

CREATE TABLE "ChildCalendarRecurTimeMember" (
  "AutoID" serial PRIMARY KEY,
  "CalendarID" varchar(64) NOT NULL,
  "UserID" varchar(64) DEFAULT NULL,
  "RecurTime" timestamp NOT NULL,
  "Email" varchar(128) DEFAULT NULL,
  "MobilePhone" varchar(32) DEFAULT NULL,
  "GroupID" varchar(64) DEFAULT NULL,
  "CatID" varchar(64) DEFAULT NULL,
  "Types" int DEFAULT NULL,
  "Status" int DEFAULT NULL,
  "ReMark" varchar(1024) DEFAULT NULL,
  "CreateTime" timestamp DEFAULT NULL,
  "RemindTime" int DEFAULT NULL,
  "RemindType" int DEFAULT NULL,
  "UpdateTime" timestamp DEFAULT NULL,
  "AccountID" varchar(64) DEFAULT NULL,
  "ProjectID" varchar(64) DEFAULT NULL,
  "VoiceRemind" boolean DEFAULT false
); 

CREATE TABLE "ThirdUser" (
  "AutoID" serial PRIMARY KEY,
  "ThirdID" varchar(50) NOT NULL,
  "CalendarID" varchar(64) NOT NULL,
  "RecurTime" timestamp DEFAULT NULL,
  "CreateTime" timestamp NOT NULL,
  "EditTime" timestamp NOT NULL,
  "NickName" varchar(50) DEFAULT NULL,
  "Face" varchar(200) DEFAULT NULL
);

CREATE TABLE "User_CalCategory_Order" (
  "AutoID" serial PRIMARY KEY,
  "UserID" varchar(64) DEFAULT NULL,
  "CatID" varchar(64) DEFAULT NULL,
  "DisplayOrder" int DEFAULT NULL,
  "ProjectID" varchar(64) DEFAULT NULL,
  "CreateTime" timestamp DEFAULT NULL,
  "AccountID" varchar(64) DEFAULT NULL
);

CREATE UNIQUE INDEX uk_c_calendarid ON Calendar USING btree (CalendarID);
CREATE INDEX idx_c_caid ON Calendar USING btree (CreateAccountID);
CREATE INDEX idx_c_eventend ON Calendar USING btree (EventEnd);
CREATE INDEX idx_c_starttime_calendarid ON Calendar USING btree (StartTime,CalendarID);
CREATE UNIQUE INDEX uk_cc_catid ON Calendar_Category USING btree (CatID);
CREATE INDEX idx_cc_aid_catid ON Calendar_Category USING btree (AccountID,CatID);
CREATE INDEX idx_cm_calendarid ON Calendar_Member USING btree (CalendarID);
CREATE INDEX idx_cm_aid ON Calendar_Member USING btree (AccountID);
CREATE UNIQUE INDEX uk_ccr_calendarid_recur ON ChildCalendarRecurTime USING btree (CalendarID,RecurTime);
CREATE INDEX idx_ccr_starttime_endtime ON ChildCalendarRecurTime USING btree (StartTime,EndTime);
CREATE INDEX idx_ccrtm_calendarid_recurtime_aid ON ChildCalendarRecurTimeMember USING btree (CalendarID,RecurTime,AccountID);
CREATE INDEX idx_tu_calendarid ON ThirdUser USING btree (CalendarID);
CREATE INDEX idx_uco_aid_catid ON User_CalCategory_Order USING btree (AccountID,CatID);