CREATE DATABASE IF NOT EXISTS MDProject DEFAULT CHARACTER SET utf8mb4 DEFAULT COLLATE utf8mb4_general_ci;
USE MDProject;

CREATE TABLE `Account` (
  `AutoId` int(11) NOT NULL AUTO_INCREMENT,
  `AccountId` char(36) NOT NULL,
  `MobilePhone` varchar(32) DEFAULT NULL,
  `Email` varchar(128) DEFAULT NULL,
  `Password` varchar(64) DEFAULT NULL,
  `CreateTime` datetime(6) DEFAULT NULL,
  `UpdateTime` datetime(6) DEFAULT NULL,
  `Status` int(11) DEFAULT NULL,
  `SourceType` int(11) DEFAULT NULL,
  PRIMARY KEY (`AutoId`),
  KEY `idx_aid` (`AccountId`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE `Account_Authentication` (
  `AutoId` int(11) NOT NULL AUTO_INCREMENT,
  `SourceId` varchar(128) DEFAULT NULL,
  `AuthType` int(11) DEFAULT NULL,
  `AccountId` char(36) DEFAULT NULL,
  `Account` varchar(128) DEFAULT NULL,
  `Token` varchar(256) DEFAULT NULL,
  `Status` int(11) DEFAULT NULL,
  `Number` int(11) DEFAULT NULL,
  `ProjectId` char(36) DEFAULT NULL,
  `CreateAccountId` char(36) DEFAULT NULL,
  `CreateTime` datetime(6) DEFAULT NULL,
  `UpdateTime` datetime(6) DEFAULT NULL,
  `VerifyCode` varchar(10) DEFAULT NULL,
  `LastModifyAccountId` char(36) DEFAULT NULL,
  PRIMARY KEY (`AutoId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE `Account_Bind_Email` (
  `AutoId` int(11) NOT NULL AUTO_INCREMENT,
  `AccountId` char(36) DEFAULT NULL,
  `Email` varchar(50) DEFAULT NULL,
  `ProjectId` char(36) DEFAULT NULL,
  `CreateTime` datetime(6) DEFAULT NULL,
  `UserId` char(36) DEFAULT NULL,
  `IsVerify` int(11) DEFAULT NULL,
  `State` int(11) DEFAULT NULL,
  PRIMARY KEY (`AutoId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE `Account_Detail` (
  `AutoId` int(11) NOT NULL AUTO_INCREMENT,
  `AccountId` char(36) DEFAULT NULL,
  `Name` varchar(128) DEFAULT NULL,
  `Title` varchar(128) DEFAULT NULL,
  `Description` varchar(512) DEFAULT NULL,
  `StartDate` varchar(10) DEFAULT NULL,
  `EndDate` varchar(10) DEFAULT NULL,
  `DetailType` int(11) DEFAULT NULL,
  `CreateTime` datetime(6) DEFAULT NULL,
  `UpdateTime` datetime(6) DEFAULT NULL,
  PRIMARY KEY (`AutoId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE `Account_Friends` (
  `AutoId` int(11) NOT NULL AUTO_INCREMENT,
  `AccountIdA` char(36) DEFAULT NULL,
  `AccountIdB` char(36) DEFAULT NULL,
  `Status` int(11) DEFAULT NULL,
  `Message` varchar(100) DEFAULT NULL,
  `CreateAccountId` char(36) DEFAULT NULL,
  `CreateTime` datetime(6) DEFAULT NULL,
  `UpdateTime` datetime(6) DEFAULT NULL,
  PRIMARY KEY (`AutoId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE `Account_Medal` (
  `AutoId` int(11) NOT NULL AUTO_INCREMENT,
  `MedalId` char(36) NOT NULL,
  `ProjectId` char(36) DEFAULT NULL,
  `IsSystem` bit(1) DEFAULT NULL,
  `MedalName` varchar(512) DEFAULT NULL,
  `MedalType` tinyint(4) DEFAULT NULL,
  `SysMedalType` tinyint(4) DEFAULT NULL,
  `Description` varchar(1024) DEFAULT NULL,
  `IsEnable` bit(1) DEFAULT NULL,
  `Remark` varchar(1024) DEFAULT NULL,
  `LargePath` varchar(512) DEFAULT NULL,
  `MiddlePath` varchar(512) DEFAULT NULL,
  `SmallPath` varchar(512) DEFAULT NULL,
  `CreateAccount` char(36) DEFAULT NULL,
  `CreateTime` datetime(6) DEFAULT NULL,
  `UpdateTime` datetime(6) DEFAULT NULL,
  PRIMARY KEY (`AutoId`),
  KEY `idx_mid` (`MedalId`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE `Account_MedalGrantLog` (
  `AutoId` int(11) NOT NULL AUTO_INCREMENT,
  `GrantId` char(36) NOT NULL,
  `MedalId` char(36) DEFAULT NULL,
  `ProjectId` char(36) DEFAULT NULL,
  `FromId` char(36) DEFAULT NULL,
  `ToAccountId` char(36) DEFAULT NULL,
  `Remark` varchar(1024) DEFAULT NULL,
  `IsShow` bit(1) DEFAULT NULL,
  `IsGet` bit(1) DEFAULT NULL,
  `CreateTime` datetime(6) DEFAULT NULL,
  `UpdateTime` datetime(6) DEFAULT NULL,
  PRIMARY KEY (`AutoId`),
  KEY `idx_gid` (`GrantId`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE `Account_Scale` (
  `AutoID` int(11) NOT NULL AUTO_INCREMENT,
  `AccountId` char(36) DEFAULT NULL,
  `Type` tinyint(4) DEFAULT NULL,
  `CreateTime` datetime(6) DEFAULT NULL,
  PRIMARY KEY (`AutoID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE `Account_Setting` (
  `AutoId` int(11) NOT NULL AUTO_INCREMENT,
  `AccountId` char(36) DEFAULT NULL,
  `SettingName` varchar(64) DEFAULT NULL,
  `SettingValue` varchar(512) DEFAULT NULL,
  `CreateTime` datetime(6) DEFAULT NULL,
  `UpdateTime` datetime(6) DEFAULT NULL,
  PRIMARY KEY (`AutoId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE `AccountExpand` (
  `AutoId` int(11) NOT NULL AUTO_INCREMENT,
  `AccountId` char(36) NOT NULL,
  `Mark` int(11) DEFAULT NULL,
  `LeftMark` int(11) DEFAULT NULL,
  `Num_Login` int(11) DEFAULT NULL,
  `Num_View` int(11) DEFAULT NULL,
  `Num_Post` int(11) DEFAULT NULL,
  `Num_Comment` int(11) DEFAULT NULL,
  `LastLoginTime` datetime(6) DEFAULT NULL,
  `CurrentLoginTime` datetime(6) DEFAULT NULL,
  PRIMARY KEY (`AutoId`),
  KEY `idx_aid` (`AccountId`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE `AccountInfo` (
  `AutoId` int(11) NOT NULL AUTO_INCREMENT,
  `AccountId` char(36) NOT NULL,
  `CompanyName` varchar(128) DEFAULT NULL,
  `Profession` varchar(128) DEFAULT NULL,
  `Avatar` varchar(128) DEFAULT NULL,
  `Fullname` varchar(128) DEFAULT NULL,
  `Gender` smallint(6) DEFAULT NULL,
  `Birthdate` date DEFAULT NULL,
  `IM_QQ` varchar(16) DEFAULT NULL,
  `SNS_Sina` varchar(128) DEFAULT NULL,
  `SNS_QQ` varchar(128) DEFAULT NULL,
  `SNS_Linkedin` varchar(128) DEFAULT NULL,
  `WeiXin` varchar(128) DEFAULT NULL,
  `AppId` char(36) DEFAULT NULL,
  `CreateTime` datetime(6) DEFAULT NULL,
  `FirstCode` varchar(2) DEFAULT NULL,
  `Address` varchar(500) DEFAULT NULL,
  `ContactMobilePhone` varchar(32) DEFAULT NULL,
  `UpdateTime` datetime(6) DEFAULT NULL,
  PRIMARY KEY (`AutoId`),
  KEY `idx_aid` (`AccountId`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE `AccountStatistic` (
  `AutoId` int(11) NOT NULL AUTO_INCREMENT,
  `AccountID` char(36) NOT NULL,
  `CompanyName` varchar(128) DEFAULT NULL,
  `Fullname` varchar(128) DEFAULT NULL,
  `Gender` tinyint(1) DEFAULT NULL,
  `Birthdate` datetime(6) DEFAULT NULL,
  `IM_QQ` varchar(16) DEFAULT NULL,
  `MobilePhone` varchar(32) DEFAULT NULL,
  `Email` varchar(128) DEFAULT NULL,
  `Status` tinyint(4) DEFAULT NULL,
  `SNS_Sina` varchar(128) DEFAULT NULL,
  `SNS_QQ` varchar(128) DEFAULT NULL,
  `SNS_Linkedin` varchar(128) DEFAULT NULL,
  `WeiXin` varchar(128) DEFAULT NULL,
  `CreateTime` datetime(6) DEFAULT NULL,
  `AppId` char(36) DEFAULT NULL,
  `FromRegister` varchar(100) DEFAULT NULL,
  `Num_Login` int(11) DEFAULT NULL,
  `Num_View` int(11) DEFAULT NULL,
  `Num_Post` int(11) DEFAULT NULL,
  `Num_Comment` int(11) DEFAULT NULL,
  `Num_Task` int(11) DEFAULT NULL,
  `Num_TaskComment` int(11) DEFAULT NULL,
  `Num_CreateCalendar` int(11) DEFAULT NULL,
  `Num_ParticipateCalendar` int(11) DEFAULT NULL,
  `Num_File` int(11) DEFAULT NULL,
  `Num_Image` int(11) DEFAULT NULL,
  `Num_Voice` int(11) DEFAULT NULL,
  `Num_Video` int(11) DEFAULT NULL,
  `VIPEndDate` datetime(6) DEFAULT NULL,
  `LastLoginTime` datetime(6) DEFAULT NULL,
  `NowMonthFlow` int(11) DEFAULT NULL,
  `FlowResetDay` int(11) DEFAULT NULL,
  `StorageSpace` int(11) DEFAULT NULL,
  `Num_Invite` int(11) DEFAULT NULL,
  `Num_Project` int(11) DEFAULT NULL,
  `Avatar` varchar(128) DEFAULT NULL,
  `UpdateTime` datetime(6) DEFAULT NULL,
  PRIMARY KEY (`AutoId`),
  KEY `idx_aid` (`AccountID`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE `Project` (
  `AutoID` int(11) NOT NULL AUTO_INCREMENT,
  `ProjectID` char(36) NOT NULL,
  `CompanyName` varchar(128) DEFAULT NULL,
  `CompanyNameEn` varchar(256) DEFAULT NULL,
  `CompanyDisplayName` varchar(128) DEFAULT NULL,
  `Status` tinyint(4) DEFAULT NULL,
  `GeographyID` int(11) DEFAULT NULL,
  `IndustryID` tinyint(4) DEFAULT NULL,
  `Balance` decimal(18,4) DEFAULT NULL,
  `CreateUser` char(36) DEFAULT NULL,
  `LastModifyUser` char(36) DEFAULT NULL,
  `ParentID` char(36) DEFAULT NULL,
  `CreateTime` datetime(6) DEFAULT NULL,
  `UpdateTime` datetime(6) DEFAULT NULL,
  PRIMARY KEY (`AutoID`),
  KEY `idx_pid` (`ProjectID`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE `Project_Department`
(
    `AutoID`          int(11) NOT NULL AUTO_INCREMENT,
    `DepartmentID`    char(36) NOT NULL,
    `DepartmentName`  varchar(128)      DEFAULT NULL,
    `CreateUser`      char(36)          DEFAULT NULL,
    `LastModifyUser`  char(36)          DEFAULT NULL,
    `ProjectID`       char(36)          DEFAULT NULL,
    `MappingGroupID`  char(36)          DEFAULT NULL,
    `CreateTime`      datetime(6) DEFAULT NULL,
    `UpdateTime`      datetime(6) DEFAULT NULL,
    `ParentId`        char(36)          DEFAULT NULL,
    `ChargeAccountId` varchar(1024)     DEFAULT NULL,
    `SortIndex`       bigint(20) NOT NULL DEFAULT 0,
    `Deleted`         bit(1)   NOT NULL DEFAULT b'0',
    PRIMARY KEY (`AutoID`),
    KEY               `idx_pid_del` (`ProjectID`,`Deleted`) USING BTREE,
    KEY               `idx_pid_parid_del` (`ProjectID`,`ParentId`,`Deleted`) USING BTREE,
    KEY               `idx_did_pid_del` (`DepartmentID`,`ProjectID`,`Deleted`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;


CREATE TABLE `Project_DepartmentAccount` (
  `AutoId` int(11) NOT NULL AUTO_INCREMENT,
  `ProjectId` char(36) NOT NULL,
  `DepartmentId` char(36) NOT NULL,
  `AccountId` char(36) NOT NULL,
  `IsMainDepartment` bit(1) NOT NULL DEFAULT b'0',
  `IsManager` bit(1) NOT NULL DEFAULT b'0',
  `CreateTime` datetime(6) NOT NULL,
  `CreateUser` char(36) DEFAULT NULL,
  `UpdateTime` datetime(6) NOT NULL,
  `LastModifyUser` char(36) DEFAULT NULL,
  `Deleted` bit(1) NOT NULL DEFAULT b'0',
  `DisplayOrder` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`AutoId`),
  KEY `idx_del` (`Deleted`) USING BTREE,
  KEY `idx_pid_did_aid_del` (`ProjectId`,`DepartmentId`,`AccountId`,`Deleted`) USING BTREE,
  KEY `idx_pid_del` (`ProjectId`,`Deleted`) USING BTREE,
  KEY `idx_pid_did_del` (`ProjectId`,`DepartmentId`,`Deleted`) USING BTREE,
  KEY `idx_pid_aid` (`ProjectId`,`AccountId`) USING BTREE,
  KEY `idx_pid_did_ord_del` (`ProjectId`,`DepartmentId`,`DisplayOrder`,`Deleted`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE `Project_JobAccount` (
  `AutoId` int(11) NOT NULL AUTO_INCREMENT,
  `ProjectId` char(36) NOT NULL,
  `JobId` char(36) NOT NULL,
  `AccountId` char(36) NOT NULL,
  `CreateUser` char(36) DEFAULT NULL,
  `CreateTime` datetime(6) NOT NULL,
  `UpdateTime` datetime(6) NOT NULL,
  `LastModifyUser` char(36) DEFAULT NULL,
  `DepartmentId` char(36) DEFAULT NULL,
  PRIMARY KEY (`AutoId`),
  KEY `idx_pid_jid_aid` (`ProjectId`,`JobId`,`AccountId`) USING BTREE,
  KEY `idx_pid_jid` (`ProjectId`,`JobId`) USING BTREE,
  KEY `idx_pid` (`ProjectId`) USING BTREE,
  KEY `idx_pid_aid` (`ProjectId`,`AccountId`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE `Project_Finance` (
  `AutoID` int(11) NOT NULL AUTO_INCREMENT,
  `ProjectID` char(36) NOT NULL,
  `Address` varchar(256) DEFAULT NULL,
  `RecipientName` varchar(64) DEFAULT NULL,
  `Postcode` varchar(16) DEFAULT NULL,
  `MobilePhone` varchar(32) DEFAULT NULL,
  `ContactPhone` varchar(32) DEFAULT NULL,
  `Fax` varchar(32) DEFAULT NULL,
  `Email` varchar(128) DEFAULT NULL,
  `EmailRecipientName` varchar(64) DEFAULT NULL,
  `InvoiceType` tinyint(4) DEFAULT NULL,
  `TaxNumber` varchar(64) DEFAULT NULL,
  `TaxBank` varchar(128) DEFAULT NULL,
  `TaxBankNumber` varchar(64) DEFAULT NULL,
  `TaxRegAddress` varchar(256) DEFAULT NULL,
  `TaxRegContactPhone` varchar(32) DEFAULT NULL,
  `IsGeneralTaxpayer` bit(1) DEFAULT NULL,
  `CreateUser` char(36) DEFAULT NULL,
  `LastModifyUser` char(36) DEFAULT NULL,
  `CreateTime` datetime(6) DEFAULT NULL,
  `UpdateTime` datetime(6) DEFAULT NULL,
  PRIMARY KEY (`AutoID`),
  KEY `idx_pid` (`ProjectID`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE `Project_Job` (
  `AutoID` int(11) NOT NULL AUTO_INCREMENT,
  `JobID` char(36) NOT NULL,
  `JobName` varchar(128) DEFAULT NULL,
  `CreateUser` char(36) DEFAULT NULL,
  `LastModifyUser` char(36) DEFAULT NULL,
  `ProjectID` char(36) DEFAULT NULL,
  `CreateTime` datetime(6) DEFAULT NULL,
  `UpdateTime` datetime(6) DEFAULT NULL,
  PRIMARY KEY (`AutoID`),
  KEY `idx_jobid` (`JobID`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE `Project_Setting` (
  `AutoID` int(11) NOT NULL AUTO_INCREMENT,
  `ProjectID` char(36) DEFAULT NULL,
  `SettingName` varchar(64) DEFAULT NULL,
  `SettingValue` varchar(255) DEFAULT NULL,
  `CreateUser` char(36) DEFAULT NULL,
  `LastModifyUser` char(36) DEFAULT NULL,
  `CreateTime` datetime(6) DEFAULT NULL,
  `UpdateTime` datetime(6) DEFAULT NULL,
  PRIMARY KEY (`AutoID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE `Project_Source` (
  `AutoID` int(11) NOT NULL AUTO_INCREMENT,
  `Source` tinyint(4) DEFAULT NULL,
  `CreateUser` char(36) DEFAULT NULL,
  `ProjectID` char(36) DEFAULT NULL,
  `CreateTime` datetime(6) DEFAULT NULL,
  PRIMARY KEY (`AutoID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE `Project_WorkSite` (
  `AutoID` int(11) NOT NULL AUTO_INCREMENT,
  `WorkSiteID` char(36) NOT NULL,
  `WorkSiteName` varchar(128) DEFAULT NULL,
  `CreateUser` char(36) DEFAULT NULL,
  `LastModifyUser` char(36) DEFAULT NULL,
  `ProjectID` char(36) DEFAULT NULL,
  `CreateTime` datetime(6) DEFAULT NULL,
  `UpdateTime` datetime(6) DEFAULT NULL,
  PRIMARY KEY (`AutoID`),
  KEY `idx_wid` (`WorkSiteID`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE `ProjectAuthorization` (
  `AutoId` int(11) NOT NULL AUTO_INCREMENT,
  `ProjectId` char(36) DEFAULT NULL,
  `AppKey` varchar(100) DEFAULT NULL,
  `SecretKey` varchar(100) DEFAULT NULL,
  `ExpireTime` datetime(6) DEFAULT NULL,
  `Type` tinyint(4) DEFAULT NULL,
  `CreateTime` datetime(6) DEFAULT NULL,
  `CreateAccountId` char(36) DEFAULT NULL,
  `Status` tinyint(4) DEFAULT NULL,
  `Sign` varchar(512) DEFAULT NULL,
  PRIMARY KEY (`AutoId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE `RoutingAccount` (
  `AutoID` int(11) NOT NULL AUTO_INCREMENT,
  `AccountId` char(36) DEFAULT NULL,
  `UserID` char(36) DEFAULT NULL,
  `ProjectID` char(36) DEFAULT NULL,
  `Status` tinyint(4) DEFAULT NULL,
  `ServerID` char(36) DEFAULT NULL,
  `CreateTime` datetime(6) DEFAULT NULL,
  `UpdateTime` datetime(6) DEFAULT NULL,
  `CompanyName` varchar(1000) DEFAULT NULL,
  `UserType` tinyint(4) DEFAULT NULL,
  PRIMARY KEY (`AutoID`),
  UNIQUE KEY `uidx_pid_aid` (`ProjectID`,`AccountId`) USING BTREE,
  KEY `idx_aid_pid` (`AccountId`,`ProjectID`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE `RoutingProject` (
  `AutoID` int(11) NOT NULL AUTO_INCREMENT,
  `ProjectID` char(36) NOT NULL,
  `ParentID` char(36) DEFAULT NULL,
  `ServerID` char(36) DEFAULT NULL,
  `CompanyName` varchar(128) DEFAULT NULL,
  `SubDomain` varchar(64) DEFAULT NULL,
  `BaseAuthenticationDomain` varchar(128) DEFAULT NULL,
  `ExpandAuthenticationDomain` varchar(512) DEFAULT NULL,
  `CreateTime` datetime(6) DEFAULT NULL,
  `UpdateTime` datetime(6) DEFAULT NULL,
  PRIMARY KEY (`AutoID`),
  KEY `idx_pid` (`ProjectID`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin;

CREATE TABLE `RoutingProjectExpand` (
  `AutoID` int(11) NOT NULL AUTO_INCREMENT,
  `ProjectID` char(36) NOT NULL,
  `CompanyName` varchar(128) DEFAULT NULL,
  `IsEMail` bit(1) DEFAULT NULL,
  `PaidType` tinyint(4) DEFAULT NULL,
  `Geography` int(11) DEFAULT NULL,
  `Industry` int(11) DEFAULT NULL,
  `Num_User` int(11) DEFAULT NULL,
  `Num_Group` int(11) DEFAULT NULL,
  `Num_Post` int(11) DEFAULT NULL,
  `Num_Comment` int(11) DEFAULT NULL,
  `Num_Pic` int(11) DEFAULT NULL,
  `Num_Doc` int(11) DEFAULT NULL,
  `Num_QA` int(11) DEFAULT NULL,
  `Num_Task` int(11) DEFAULT NULL,
  `Num_Sms` int(11) DEFAULT NULL,
  `Filesize_Pic` decimal(20,3) DEFAULT NULL,
  `Filesize_Doc` decimal(20,3) DEFAULT NULL,
  `LoginCountByLastWeek` int(11) DEFAULT NULL,
  `PostCountByLastWeek` int(11) DEFAULT NULL,
  `CommentCountByLastWeek` int(11) DEFAULT NULL,
  `LastLoginTime` datetime(6) DEFAULT NULL,
  `InvoiceType` int(11) DEFAULT NULL,
  `CreateUser` char(36) DEFAULT NULL,
  `CreateTime` datetime(6) DEFAULT NULL,
  `UpdateTime` datetime(6) DEFAULT NULL,
  `Vitality` decimal(18,0) DEFAULT NULL,
  `Num_Calander` int(11) DEFAULT NULL,
  `Num_Voice` int(11) DEFAULT NULL,
  `Num_Video` int(11) DEFAULT NULL,
  `Num_TaskReply` int(11) DEFAULT NULL,
  `Num_Login` int(11) DEFAULT NULL,
  PRIMARY KEY (`AutoID`),
  KEY `idx_pid` (`ProjectID`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE `RoutingProjectExpandForOther` (
  `AutoID` int(11) NOT NULL AUTO_INCREMENT,
  `ProjectID` char(36) NOT NULL,
  `Balance` decimal(10,2) DEFAULT NULL,
  `PayStatus` int(11) DEFAULT NULL,
  `UpdateTime` datetime(6) DEFAULT NULL,
  PRIMARY KEY (`AutoID`),
  KEY `idx_pid` (`ProjectID`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE `RoutingUserExpand` (
  `AutoID` int(11) NOT NULL AUTO_INCREMENT,
  `UserID` char(36) DEFAULT NULL,
  `ProjectID` char(36) DEFAULT NULL,
  `CompanyName` varchar(128) DEFAULT NULL,
  `Num_ProjectUsers` int(11) DEFAULT NULL,
  `Email` varchar(128) DEFAULT NULL,
  `Status` int(11) DEFAULT NULL,
  `IsAdmin` tinyint(4) DEFAULT NULL,
  `UserType` int(11) DEFAULT NULL,
  `Fullname` varchar(128) DEFAULT NULL,
  `Mark` int(11) DEFAULT NULL,
  `LastMark` int(11) DEFAULT NULL,
  `Grade` varchar(64) DEFAULT NULL,
  `Avatar` varchar(128) DEFAULT NULL,
  `Gender` int(11) DEFAULT NULL,
  `Birthdate` date DEFAULT NULL,
  `Job` varchar(64) DEFAULT NULL,
  `Department` varchar(64) DEFAULT NULL,
  `City` varchar(64) DEFAULT NULL,
  `MobilePhone` varchar(32) DEFAULT NULL,
  `ContactPhone` varchar(32) DEFAULT NULL,
  `Num_Login` int(11) DEFAULT NULL,
  `Num_View` int(11) DEFAULT NULL,
  `Num_Follower` int(11) DEFAULT NULL,
  `Num_Concern` int(11) DEFAULT NULL,
  `Num_Post` int(11) DEFAULT NULL,
  `Num_Comment` int(11) DEFAULT NULL,
  `LastLoginTime` datetime(6) DEFAULT NULL,
  `CreateTime` datetime(6) DEFAULT NULL,
  `UpdateTime` datetime(6) DEFAULT NULL,
  `AccountID` varchar(128) DEFAULT NULL,
  `DepartmentId` char(36) DEFAULT NULL,
  `JobId` char(36) DEFAULT NULL,
  PRIMARY KEY (`AutoID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE `FixedData` (
  `AutoID` int(11) NOT NULL AUTO_INCREMENT,
  `DataID` int(11) DEFAULT NULL,
  `DataName` varchar(128) DEFAULT NULL,
  `ParentDataID` int(11) DEFAULT NULL,
  `DataType` int(11) DEFAULT NULL,
  PRIMARY KEY (`AutoID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE `ImportUserInfo` (
  `AutoId` int(11) NOT NULL AUTO_INCREMENT,
  `ProjectID` char(36) DEFAULT NULL,
  `Status` int(11) DEFAULT NULL,
  `Fullname` varchar(100) DEFAULT NULL,
  `Account` varchar(100) DEFAULT NULL,
  `Department` varchar(100) DEFAULT NULL,
  `Job` varchar(100) DEFAULT NULL,
  `CompanyName` varchar(100) DEFAULT NULL,
  `WorkSite` varchar(100) DEFAULT NULL,
  `JobNumber` varchar(100) DEFAULT NULL,
  `ContactPhone` varchar(100) DEFAULT NULL,
  `CreateAccountId` char(36) DEFAULT NULL,
  `CreateTime` datetime(6) DEFAULT NULL,
  `UpdateTime` datetime(6) DEFAULT NULL,
  `DepartmentId` char(36) DEFAULT NULL,
  `AccountId` char(36) DEFAULT NULL,
  `WorkSiteId` char(36) DEFAULT NULL,
  `JobId` char(36) DEFAULT NULL,
  `DepartmentIds` varchar(1000) DEFAULT NULL,
  `JobIds` varchar(1000) DEFAULT NULL,
  `OrgRoleIds` varchar(1000) DEFAULT NULL,
  `UseMultiJobs` bit(1) DEFAULT 0 NOT NULL,
  `DepartmentJobIdMaps` varchar(2000) DEFAULT NULL,
  PRIMARY KEY (`AutoId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE `LinkAuthentication` (
  `AutoId` int(11) NOT NULL AUTO_INCREMENT,
  `SourceId` varchar(128) DEFAULT NULL,
  `InviteFromType` int(11) DEFAULT NULL,
  `Token` varchar(255) DEFAULT NULL,
  `ProjectId` char(36) DEFAULT NULL,
  `CreateAccountId` char(36) DEFAULT NULL,
  `LinkFromType` int(11) DEFAULT NULL,
  `DeadTime` datetime(6) DEFAULT NULL,
  `CreateTime` datetime(6) DEFAULT NULL,
  `UpdateTime` datetime(6) DEFAULT NULL,
  PRIMARY KEY (`AutoId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE `UsersCard` (
  `AutoId` int(11) NOT NULL AUTO_INCREMENT,
  `UserId` char(36) NOT NULL,
  `AccountId` char(36) DEFAULT NULL,
  `ProjectId` char(36) DEFAULT NULL,
  `CompanyName` varchar(128) DEFAULT NULL,
  `Fullname` varchar(128) DEFAULT NULL,
  `Job` varchar(64) DEFAULT NULL,
  `Department` varchar(128) DEFAULT NULL,
  `ContactPhone` varchar(32) DEFAULT NULL,
  `WorkSite` varchar(128) DEFAULT NULL,
  `JobNumber` varchar(128) DEFAULT NULL,
  `Status` int(11) DEFAULT NULL,
  `LastModifyUser` char(36) DEFAULT NULL,
  `CreateTime` datetime(6) DEFAULT NULL,
  `UpdateTime` datetime(6) DEFAULT NULL,
  `DepartmentId` char(36) DEFAULT NULL,
  `WorkSiteId` char(36) DEFAULT NULL,
  `JobId` char(36) DEFAULT NULL,
  `UseMultiJobs` bit(1) DEFAULT 0 NOT NULL,
  PRIMARY KEY (`AutoId`),
  UNIQUE KEY `uidx_pid_aid` (`ProjectId`,`AccountId`) USING BTREE,
  KEY `idx_aid_pid` (`AccountId`, `ProjectId`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;


CREATE TABLE `Role` (
  `AutoId` int(11) NOT NULL AUTO_INCREMENT,
  `ProjectId` varchar(50) DEFAULT NULL,
  `RoleId` varchar(50) DEFAULT NULL,
  `RoleName` varchar(50) DEFAULT NULL,
  `CreateUser` varchar(50) DEFAULT NULL,
  `CreateTime` datetime DEFAULT NULL,
  `LastModifyUser` varchar(50) DEFAULT NULL,
  `UpdateTime` datetime DEFAULT NULL,
  `IsDelete` bit(1) DEFAULT NULL,
  `EntityId` varchar(50) DEFAULT NULL,
  `EntityType` int(11) DEFAULT NULL,
  `RoleType` int(11) DEFAULT NULL,
  PRIMARY KEY (`AutoId`),
  KEY `idx_get_role_pid` (`ProjectId`,`RoleId`) USING HASH,
  KEY `idx_get_et_eid_rid` (`RoleId`,`EntityId`,`EntityType`) USING HASH
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE `RolePermission` (
  `AutoId` int(11) NOT NULL AUTO_INCREMENT,
  `ProjectId` varchar(50) DEFAULT NULL,
  `RoleId` varchar(50) DEFAULT NULL,
  `PermissionId` int(11) DEFAULT NULL,
  `CreateUser` varchar(50) DEFAULT NULL,
  `CreateTime` datetime DEFAULT NULL,
  `LastModifyUser` varchar(50) DEFAULT NULL,
  `UpdateTime` datetime DEFAULT NULL,
  `EntityId` varchar(50) DEFAULT NULL,
  `EntityType` int(11) DEFAULT NULL,
  PRIMARY KEY (`AutoId`),
  KEY `idx_pid_pmsid` (`ProjectId`,`PermissionId`) USING HASH,
  KEY `idx_pid_rid` (`ProjectId`,`RoleId`) USING HASH,
  KEY `idx_et_eid_pmsid` (`PermissionId`,`EntityId`,`EntityType`) USING HASH,
  KEY `idx_et_eid_rid` (`RoleId`,`EntityId`,`EntityType`) USING HASH
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

CREATE TABLE `Permission` (
  `AutoId` int(11) NOT NULL AUTO_INCREMENT,
  `TypeId` int(11) DEFAULT NULL,
  `TypeName` varchar(100) DEFAULT NULL,
  `PermissionId` int(11) DEFAULT NULL,
  `PermissionName` varchar(100) DEFAULT NULL,
  `IsTypeAdmin` bit(1) DEFAULT NULL,
  `Description` varchar(200) DEFAULT NULL,
  `ParentId` int(11) DEFAULT NULL,
  `OrderId` int(11) DEFAULT NULL,
  `EntityType` int(11) DEFAULT NULL,
  `HasChild` bit(1) DEFAULT NULL,
  PRIMARY KEY (`AutoId`),
  KEY `idx_et_pmsid` (`PermissionId`,`EntityType`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

CREATE TABLE `UserRole` (
  `AutoId` int(11) NOT NULL AUTO_INCREMENT,
  `AccountId` varchar(50) DEFAULT NULL,
  `ProjectId` varchar(50) DEFAULT NULL,
  `RoleId` varchar(50) DEFAULT NULL,
  `Status` int(11) DEFAULT NULL,
  `CreateUser` varchar(50) DEFAULT NULL,
  `CreateTime` datetime DEFAULT NULL,
  `LastModifyUser` varchar(50) DEFAULT NULL,
  `UpdateTime` datetime DEFAULT NULL,
  `UserScopeType` int(11) DEFAULT NULL,
  `EntityId` varchar(50) DEFAULT NULL,
  `EntityType` int(11) DEFAULT NULL,
  `OriginId` varchar(50) DEFAULT NULL,
  `OriginName` varchar(50) DEFAULT NULL,
  `OriginType` int(11) DEFAULT NULL,
  PRIMARY KEY (`AutoId`),
  KEY `idx_pid_aid` (`AccountId`,`ProjectId`) USING HASH,
  KEY `idx_pid_rid_sts` (`ProjectId`,`RoleId`,`Status`) USING HASH,
  KEY `idx_pid_status` (`ProjectId`,`Status`) USING HASH,
  KEY `idx_eid_aid` (`EntityType`,`EntityId`,`AccountId`) USING HASH,
  KEY `idx_et_eid_rid_sts` (`EntityType`,`EntityId`,`RoleId`,`Status`) USING HASH,
  KEY `idx_et_eid_sts` (`EntityType`,`EntityId`,`Status`) USING HASH
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

CREATE TABLE `Project_UserRule` (
  `AutoId` int(11) NOT NULL AUTO_INCREMENT,
  `ProjectId` char(36) NOT NULL,
  `RuleId` char(36) NOT NULL,
  `CreateTime` datetime(6) NOT NULL,
  `CreateUser` char(36) NOT NULL,
  `UpdateTime` datetime(6) NOT NULL,
  `LastModifyUser` char(36) NOT NULL,
  `RuleType` int(11) NOT NULL DEFAULT '10',
  PRIMARY KEY (`AutoId`),
  KEY `idx_pid` (`ProjectId`) USING BTREE,
  KEY `idx_rid` (`RuleId`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE `Project_UserRuleItem` (
  `AutoId` int(11) NOT NULL AUTO_INCREMENT,
  `ProjectId` char(36) NOT NULL,
  `RuleId` char(36) NOT NULL,
  `RuleItemType` int(11) NOT NULL DEFAULT '0',
  `TargetId` varchar(50) NOT NULL,
  `TargetType` int(11) NOT NULL DEFAULT '0',
  `CreateTime` datetime(6) NOT NULL,
  `CreateUser` char(36) NOT NULL,
  PRIMARY KEY (`AutoId`),
  KEY `idx_pid_rid` (`ProjectId`,`RuleId`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE `Project_Organize` (
  `AutoID` int(11) NOT NULL AUTO_INCREMENT,
  `OrganizeID` char(36) NOT NULL,
  `OrganizeGroupID` char(36) DEFAULT NULL,
  `OrganizeName` varchar(128) DEFAULT NULL,
  `ProjectID` char(36) NOT NULL,
  `Remark` text,
  `SortIndex` int(11) NOT NULL,
  `CreateUser` char(36) DEFAULT NULL,
  `LastModifyUser` char(36) DEFAULT NULL,
  `CreateTime` datetime DEFAULT NULL,
  `UpdateTime` datetime DEFAULT NULL,
  PRIMARY KEY (`AutoID`),
  KEY `idx_pid_oid` (`ProjectID`,`OrganizeID`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE `Project_OrganizeAccount` (
  `AutoId` int(11) NOT NULL AUTO_INCREMENT,
  `ProjectId` char(36) NOT NULL,
  `OrganizeId` char(36) NOT NULL,
  `AccountId` char(36) NOT NULL,
  `CreateUser` char(36) DEFAULT NULL,
  `CreateTime` datetime NOT NULL,
  `UpdateTime` datetime NOT NULL,
  `LastModifyUser` char(36) DEFAULT NULL,
  PRIMARY KEY (`AutoId`),
  KEY `idx_pid_oid_aid` (`ProjectId`,`OrganizeId`,`AccountId`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE `Project_OrgRoleChargeDepartment` (
    `AutoId` int(11) NOT NULL AUTO_INCREMENT,
    `ProjectId` char(36) NOT NULL,
    `OrgRoleId` char(36) NOT NULL,
    `AccountId` char(36) NOT NULL,
    `DepartmentId` char(36) NOT NULL,
    `IsIncludeSub` bit(1) NOT NULL DEFAULT b'1',
    `CreateUser` char(36) NOT NULL,
    `CreateTime` datetime NOT NULL,
    `UpdateTime` datetime NOT NULL,
    `LastModifyUser` char(36) NOT NULL,
    PRIMARY KEY (`AutoId`),
    KEY `idx_pid_orid` (`ProjectId`,`OrgRoleId`,`AccountId`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE `Project_OrgRoleGroup` (
    `AutoID` int(11) NOT NULL AUTO_INCREMENT,
    `ProjectID` char(36) NOT NULL,
    `OrganizeGroupID` char(36) NOT NULL,
    `OrganizeGroupName` varchar(128),
    `SortIndex` int DEFAULT 0 NOT NULL,
    `CreateUser` char(36) NOT NULL,
    `LastModifyUser` char(36) NOT NULL,
    `CreateTime` datetime NOT NULL,
    `UpdateTime` datetime NOT NULL,
    PRIMARY KEY (`AutoId`),
    KEY `idx_pid` (`ProjectId`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;