USE MDCalendar;

CREATE TABLE Calendar (
  "AutoID" int IDENTITY(1, 1) PRIMARY KEY,
  "CalendarID" varchar(64) NOT NULL,
  "CalendarName" varchar(512) DEFAULT NULL,
  "StartTime" datetime(6) DEFAULT NULL,
  "EndTime" datetime(6) DEFAULT NULL,
  "IsAllDay" boolean DEFAULT NULL,
  "Address" varchar(512) DEFAULT NULL,
  "Description" varchar(1024) DEFAULT NULL,
  "Types" int DEFAULT NULL,
  "Sequence" int DEFAULT 0,
  "IsRecur" boolean DEFAULT 0,
  "Frequency" int DEFAULT 0,
  "Interval" int DEFAULT 1,
  "RecurCount" int DEFAULT 0,
  "UntilDate" datetime(6) DEFAULT NULL,
  "WeekDay" int DEFAULT NULL,
  "EventStart" datetime(6) DEFAULT NULL,
  "EventEnd" datetime(6) DEFAULT NULL,
  "AppID" varchar(64) DEFAULT NULL,
  "IsDelete" boolean DEFAULT 0,
  "CreateTime" datetime(6) DEFAULT NULL,
  "UpdateTime" datetime(6) DEFAULT NULL,
  "Locked" boolean DEFAULT NULL,
  "CreateAccountID" varchar(64) DEFAULT NULL,
  "IsPrivate" boolean NOT NULL DEFAULT 0
);

CREATE TABLE Calendar_Category (
  "AutoID" int IDENTITY(1, 1),
  "CatID" varchar(64) NOT NULL,
  "Color" int DEFAULT NULL,
  "CatName" varchar(400) DEFAULT NULL,
  "CreateTime" datetime(6) DEFAULT NULL,
  "AccountID" varchar(64) DEFAULT NULL,
  PRIMARY KEY ("AutoID")
);

CREATE TABLE Calendar_Member (
  "AutoID" int IDENTITY(1, 1),
  "CalendarID" varchar(64) NOT NULL,
  "Email" varchar(128) DEFAULT NULL,
  "MobilePhone" varchar(32) DEFAULT NULL,
  "CatID" varchar(128) DEFAULT NULL,
  "Types" int DEFAULT NULL,
  "Status" int DEFAULT NULL,
  "ReMark" varchar(1024) DEFAULT NULL,
  "CreateTime" datetime(6) DEFAULT NULL,
  "RemindTime" int DEFAULT NULL,
  "RemindType" int DEFAULT NULL,
  "UpdateTime" datetime(6) DEFAULT NULL,
  "AccountID" varchar(64) DEFAULT NULL,
  "VoiceRemind" boolean DEFAULT 0,
  PRIMARY KEY ("AutoID")
);

CREATE TABLE ChildCalendarRecurTime (
  "AutoID" int IDENTITY(1, 1),
  "CalendarID" varchar(64) NOT NULL,
  "RecurTime" datetime(6) NOT NULL,
  "StartTime" datetime(6) NOT NULL,
  "Status" int DEFAULT NULL,
  "CalendarName" varchar(512) DEFAULT NULL,
  "EndTime" datetime(6) DEFAULT NULL,
  "IsAllDay" boolean DEFAULT NULL,
  "Address" varchar(512) DEFAULT NULL,
  "Description" varchar(1024) DEFAULT NULL,
  "Types" int DEFAULT NULL,
  "Sequence" int DEFAULT NULL,
  "CreateTime" datetime(6) DEFAULT NULL,
  "UpdateTime" datetime(6) DEFAULT NULL,
  "Locked" boolean DEFAULT NULL,
  "CreateAccountID" varchar(64) DEFAULT NULL,
  "IsPrivate" boolean NOT NULL DEFAULT 0,
  PRIMARY KEY ("AutoID")
); 

CREATE TABLE ChildCalendarRecurTimeMember (
  "AutoID" int IDENTITY(1, 1),
  "CalendarID" varchar(64) NOT NULL,
  "RecurTime" datetime(6) NOT NULL,
  "Email" varchar(128) DEFAULT NULL,
  "MobilePhone" varchar(32) DEFAULT NULL,
  "GroupID" varchar(64) DEFAULT NULL,
  "CatID" varchar(64) DEFAULT NULL,
  "Types" int DEFAULT NULL,
  "Status" int DEFAULT NULL,
  "ReMark" varchar(1024) DEFAULT NULL,
  "CreateTime" datetime(6) DEFAULT NULL,
  "RemindTime" int DEFAULT NULL,
  "RemindType" int DEFAULT NULL,
  "UpdateTime" datetime(6) DEFAULT NULL,
  "AccountID" varchar(64) DEFAULT NULL,
  "VoiceRemind" boolean DEFAULT 0,
  PRIMARY KEY ("AutoID")
); 

CREATE TABLE ThirdUser (
  "AutoID" int IDENTITY(1, 1),
  "ThirdID" varchar(50) NOT NULL,
  "CalendarID" varchar(64) NOT NULL,
  "RecurTime" datetime(6) DEFAULT NULL,
  "CreateTime" datetime(6) NOT NULL,
  "EditTime" datetime(6) NOT NULL,
  "NickName" varchar(50) DEFAULT NULL,
  "Face" varchar(200) DEFAULT NULL,
  PRIMARY KEY ("AutoID")
);

CREATE TABLE User_CalCategory_Order (
  "AutoID" int IDENTITY(1, 1),
  "CatID" varchar(64) DEFAULT NULL,
  "DisplayOrder" int DEFAULT NULL,
  "CreateTime" datetime(6) DEFAULT NULL,
  "AccountID" varchar(64) DEFAULT NULL,
  PRIMARY KEY ("AutoID")
);

CREATE UNIQUE INDEX uk_c_calendarid ON Calendar("CalendarID");
CREATE INDEX idx_c_caid ON Calendar("CreateAccountID");
CREATE INDEX idx_c_eventend ON Calendar("EventEnd");
CREATE INDEX idx_c_starttime_calendarid ON Calendar("StartTime","CalendarID");
CREATE UNIQUE INDEX uk_cc_catid ON Calendar_Category("CatID");
CREATE INDEX idx_cc_aid_catid ON Calendar_Category("AccountID","CatID");
CREATE INDEX idx_cm_calendarid ON Calendar_Member("CalendarID");
CREATE INDEX idx_cm_aid ON Calendar_Member("AccountID");
CREATE UNIQUE INDEX uk_ccr_calendarid_recur ON ChildCalendarRecurTime("CalendarID","RecurTime");
CREATE INDEX idx_ccr_starttime_endtime ON ChildCalendarRecurTime("StartTime","EndTime");
CREATE INDEX idx_ccrtm_calendarid_recurtime_aid ON ChildCalendarRecurTimeMember("CalendarID","RecurTime","AccountID");
CREATE INDEX idx_tu_calendarid ON ThirdUser("CalendarID");
CREATE INDEX idx_uco_aid_catid ON User_CalCategory_Order("AccountID","CatID");