CREATE DATABASE IF NOT EXISTS MDStructure DEFAULT CHARACTER SET utf8mb4 DEFAULT COLLATE utf8mb4_general_ci;
USE MDStructure;

CREATE TABLE `MD_Structure` (
  `AutoId` int NOT NULL AUTO_INCREMENT,
  `StructureID` char(36) NOT NULL,
  `AccountID` varchar(64) NOT NULL,
  `UserID` char(36) DEFAULT NULL,
  `IsTop` boolean DEFAULT NULL,
  `Manager_UserID` char(36) DEFAULT NULL,
  `CreateUserID` char(36) DEFAULT NULL,
  `CreateTime` datetime(6) DEFAULT NULL,
  `ProjectID` char(36) DEFAULT NULL,
  `UpdateUserID` char(36) DEFAULT NULL,
  `UpdateTime` datetime(6) DEFAULT NULL,
  PRIMARY KEY (`AutoId`),
  KEY `idx_pid_muid` (`ProjectID`,`Manager_UserID`) USING BTREE,
  KEY `idx_prid_aid` (`ProjectID`,`AccountID`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE `StructureLog` (
  `AutoId` int NOT NULL AUTO_INCREMENT,
  `AccountId` varchar(64) DEFAULT NULL,
  `ProjectId` char(36) DEFAULT NULL,
  `ParentId` char(36) DEFAULT NULL,
  `OldParentId` char(36) DEFAULT NULL,
  `OperateId` varchar(64) DEFAULT NULL,
  `CreateTime` datetime(6) DEFAULT NULL,
  PRIMARY KEY (`AutoId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;