CREATE DATABASE IF NOT EXISTS MDApplication DEFAULT CHARACTER SET utf8mb4 DEFAULT COLLATE utf8mb4_general_ci;
USE MDApplication;

CREATE TABLE `Account_Device` (
  `AutoId` int(11) NOT NULL AUTO_INCREMENT,
  `AccountID` varchar(64) DEFAULT NULL,
  `AppID` varchar(64) DEFAULT NULL,
  `Device` varchar(256) DEFAULT NULL,
  `DeviceType` int(11) DEFAULT 0,
  `RegID` varchar(256) DEFAULT NULL,
  `NotifyType` int(11) DEFAULT NULL,
  `OSType` varchar(128) DEFAULT NULL,
  `UpdateTime` datetime(6) DEFAULT NULL,
  `Language` varchar(50) DEFAULT NULL,
  `AppVersion` varchar(30) DEFAULT NULL,
  `Source` int(11) DEFAULT NULL,
  `Channel` int(11) DEFAULT NULL,
  PRIMARY KEY (`AutoId`) USING BTREE,
  KEY `idx_device` (`Device`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE `Application` (
  `AutoID` int(11) NOT NULL AUTO_INCREMENT,
  `AppID` varchar(64) NOT NULL,
  `AppName` varchar(256) DEFAULT NULL,
  `Avatar` varchar(128) DEFAULT NULL,
  `Summary` varchar(256) DEFAULT NULL,
  `About` varchar(1024) DEFAULT NULL,
  `IS_Personal` boolean DEFAULT NULL,
  `IS_Free` boolean DEFAULT NULL,
  `IS_Private` boolean DEFAULT 0,
  `ProjectIDRange` varchar(1024) DEFAULT NULL,
  `ShowModel` tinyint(4) NOT NULL DEFAULT 0,
  `Pricing_Fee` decimal(10,2) DEFAULT 0.00,
  `Pricing_Unit` tinyint(4) DEFAULT 0,
  `Pricing_Time` tinyint(4) DEFAULT 0,
  `Pricing_Type` tinyint(4) DEFAULT 3,
  `Pricing_Mark` varchar(1024) DEFAULT NULL,
  `NoticeUrl` varchar(256) DEFAULT NULL,
  `AppUrl` varchar(128) DEFAULT NULL,
  `HomeUrl` varchar(128) DEFAULT NULL,
  `SettingUrl` varchar(128) DEFAULT NULL,
  `Consumer_Key` varchar(128) DEFAULT NULL,
  `Consumer_Secret` varchar(128) DEFAULT NULL,
  `Authorize_sign` tinyint(4) DEFAULT 0,
  `Authorize_lic` tinyint(4) DEFAULT 0,
  `Calback_Url` varchar(128) DEFAULT NULL,
  `Rating` decimal(8,2) DEFAULT NULL,
  `Num_User` int(11) DEFAULT NULL,
  `Num_Post` int(11) DEFAULT NULL,
  `ProjectID` varchar(64) DEFAULT NULL,
  `CreateUser` varchar(64) DEFAULT NULL,
  `LastModifyUser` varchar(64) DEFAULT NULL,
  `Status` smallint(6) DEFAULT NULL,
  `Type` tinyint(4) DEFAULT NULL,
  `ReMark` varchar(512) DEFAULT NULL,
  `CategoryID` varchar(64) DEFAULT NULL,
  `GeoID` int(11) NOT NULL DEFAULT 1,
  `DeviceField` varchar(512) DEFAULT NULL,
  `CreateTime` datetime(6) DEFAULT NULL,
  `UpdateTime` datetime(6) DEFAULT NULL,
  `PublicTime` datetime(6) DEFAULT NULL,
  `ApplyStatus` smallint(6) DEFAULT NULL,
  `Is_Wap` boolean DEFAULT 1,
  `SubscibeUrl` varchar(256) DEFAULT NULL,
  `AppCode` varchar(1024) DEFAULT NULL,
  `AppmdConnect` varchar(1024) DEFAULT NULL,
  `AppCompanyName` varchar(1024) DEFAULT NULL,
  `AppContact` varchar(1024) DEFAULT NULL,
  `URLScheme` varchar(1024) DEFAULT NULL,
  `AndroidSSO` boolean DEFAULT NULL,
  `IosSSO` boolean DEFAULT NULL,
  `AppEmail` varchar(1024) DEFAULT NULL,
  `H5Url` varchar(1024) DEFAULT NULL,
  `AccountID` varchar(64) DEFAULT NULL,
  `WebHookUrl` varchar(500) DEFAULT NULL,
  `Modules` varchar(100) DEFAULT NULL,
  `WebHookCode` varchar(20) DEFAULT NULL,
  `WebHookStatus` int(11) DEFAULT 1,
  PRIMARY KEY (`AutoID`) USING BTREE,
  UNIQUE KEY `uk_appid` (`AppID`) USING BTREE,
  KEY `idx_ck` (`Consumer_Key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE `Application_Admin` (
  `AutoID` int(11) NOT NULL AUTO_INCREMENT,
  `AppID` varchar(64) NOT NULL,
  `UserID` varchar(64) DEFAULT NULL,
  `ProjectID` varchar(64) DEFAULT NULL,
  `CreateUser` varchar(64) DEFAULT NULL,
  `CreateTime` datetime(6) DEFAULT NULL,
  `AccountID` varchar(64) DEFAULT NULL,
  `CreateAccountID` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`AutoID`) USING BTREE,
  KEY `idx_pid_appid` (`ProjectID`,`AppID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE `OAuth2_Access_Token` (
  `AutoId` int(11) NOT NULL AUTO_INCREMENT,
  `AccessToken` varchar(128) NOT NULL,
  `AccountID` varchar(128) NOT NULL,
  `AppID` varchar(128) NOT NULL,
  `ProjectID` varchar(128) DEFAULT NULL,
  `AccessTokenExpires` datetime(6) DEFAULT NULL,
  `RefreshToken` varchar(128) DEFAULT NULL,
  `RefreshTokenExpires` datetime(6) DEFAULT NULL,
  `CreateTime` datetime(6) DEFAULT NULL,
  PRIMARY KEY (`AutoId`) USING BTREE,
  KEY `idx_at` (`AccessToken`),
  KEY `idx_rt` (`RefreshToken`),
  KEY `idx_aid_appid` (`AccountID`,`AppID`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE `Project_Application` (
  `AutoID` int(11) NOT NULL AUTO_INCREMENT,
  `ProjectID` varchar(64) DEFAULT NULL,
  `AppID` varchar(64) DEFAULT NULL,
  `AppCustomName` varchar(128) DEFAULT NULL,
  `GroupID` varchar(1024) DEFAULT NULL,
  `Rating` tinyint(4) DEFAULT NULL,
  `Status` tinyint(4) DEFAULT NULL,
  `CreateTime` datetime(6) DEFAULT CURRENT_TIMESTAMP(6),
  `UpdateTime` datetime(6) DEFAULT CURRENT_TIMESTAMP(6),
  PRIMARY KEY (`AutoID`) USING BTREE,
  KEY `idx_pid_appid` (`ProjectID`,`AppID`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE `User_Application` (
  `AutoID` int(11) NOT NULL AUTO_INCREMENT,
  `UserID` varchar(64) DEFAULT NULL,
  `AppID` varchar(64) DEFAULT NULL,
  `DeviceMark` varchar(128) DEFAULT NULL,
  `Rating` tinyint(4) DEFAULT NULL,
  `Status` tinyint(4) DEFAULT NULL,
  `CreateTime` datetime(6) DEFAULT NULL,
  `UpdateTime` datetime(6) DEFAULT NULL,
  `DeviceType` int(11) NOT NULL DEFAULT 0,
  `RegID` varchar(128) DEFAULT NULL,
  `ProjectID` varchar(64) DEFAULT NULL,
  `AccountID` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`AutoID`) USING BTREE,
  KEY `idx_aid_appid` (`AccountID`,`AppID`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE `User_Application_Order` (
  `AutoID` int(11) NOT NULL AUTO_INCREMENT,
  `UserID` varchar(64) NOT NULL,
  `AppID` varchar(64) NOT NULL,
  `DisplayOrder` int(11) NOT NULL,
  `CreateTime` datetime(6) NOT NULL,
  `IsTop` boolean DEFAULT NULL,
  `TopOrder` int(11) DEFAULT NULL,
  `AccountID` varchar(64) DEFAULT NULL,
  `ProjectID` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`AutoID`) USING BTREE,
  KEY `idx_aid` (`AccountID`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;