CREATE DATABASE IF NOT EXISTS MDLog DEFAULT CHARACTER SET utf8mb4 DEFAULT COLLATE utf8mb4_general_ci;
USE MDLog;

CREATE TABLE `Account_ActionLog` (
  `AutoID` int(11) NOT NULL AUTO_INCREMENT,
  `AccountID` char(36) DEFAULT NULL,
  `Title` varchar(255) DEFAULT NULL,
  `Description` varchar(512) DEFAULT NULL,
  `Type` int(11) DEFAULT NULL,
  `IP` varchar(32) DEFAULT NULL,
  `ProjectID` char(36) DEFAULT NULL,
  `CreateTime` datetime(6) DEFAULT NULL,
  PRIMARY KEY (`AutoID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE `Account_CostLog` (
  `AutoID` int(11) NOT NULL AUTO_INCREMENT,
  `AccountID` char(36) DEFAULT NULL,
  `Title` varchar(255) DEFAULT NULL,
  `CostMark` int(11) DEFAULT NULL,
  `LeftMark` int(11) DEFAULT NULL,
  `ProjectID` char(36) DEFAULT NULL,
  `CreateTime` datetime(6) DEFAULT NULL,
  PRIMARY KEY (`AutoID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;


CREATE TABLE `Project_CostLog` (
  `AutoID` int(11) NOT NULL AUTO_INCREMENT,
  `ProjectID` char(36) DEFAULT NULL,
  `Type` int(11) DEFAULT NULL,
  `Title` varchar(255) DEFAULT NULL,
  `CostMark` decimal(18,4) DEFAULT NULL,
  `LeftMark` decimal(18,4) DEFAULT NULL,
  `CreateAccount` char(36) DEFAULT NULL,
  `CreateTime` datetime(6) DEFAULT NULL,
  PRIMARY KEY (`AutoID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;


CREATE TABLE `Project_CostOperateLog` (
  `AutoID` int(11) NOT NULL AUTO_INCREMENT,
  `RecordID` char(36) DEFAULT NULL,
  `OrderID` char(36) DEFAULT NULL,
  `Price` decimal(18,4) DEFAULT NULL,
  `OperateType` tinyint(4) DEFAULT NULL,
  `Remark` text,
  `CreateAccount` char(36) DEFAULT NULL,
  `ProjectID` char(36) DEFAULT NULL,
  `CreateTime` datetime(6) DEFAULT NULL,
  PRIMARY KEY (`AutoID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;


CREATE TABLE `Project_TransactionRecord` (
  `AutoID` int(11) NOT NULL AUTO_INCREMENT,
  `RecordID` char(36) DEFAULT NULL,
  `OrderID` char(36) DEFAULT NULL,
  `AppID` char(36) DEFAULT NULL,
  `RecordType` tinyint(4) DEFAULT NULL,
  `Status` tinyint(4) DEFAULT NULL,
  `Price` decimal(18,4) DEFAULT NULL,
  `Remark` text,
  `CreateAccount` char(36) DEFAULT NULL,
  `PayAccount` char(36) DEFAULT NULL,
  `ProjectID` char(36) DEFAULT NULL,
  `CreateTime` datetime(6) DEFAULT NULL,
  `CustomOverdueTime` datetime(6) DEFAULT NULL,
  `UpdateTime` datetime(6) DEFAULT NULL,
  `RecordTypeTitle` varchar(128) DEFAULT NULL,
  `ExtendId` varchar(128) DEFAULT NULL,
  PRIMARY KEY (`AutoID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
